/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded;

import com.google.protobuf.ByteString;
import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassProtocolErrorException;
import de.larsgrefer.sass.embedded.connection.CompilerConnection;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import de.larsgrefer.sass.embedded.importer.FileImporter;
import de.larsgrefer.sass.embedded.importer.Importer;
import de.larsgrefer.sass.embedded.importer.RelativeUrlImporter;
import de.larsgrefer.sass.embedded.logging.LoggingHandler;
import de.larsgrefer.sass.embedded.logging.Slf4jLoggingHandler;
import de.larsgrefer.sass.embedded.util.ProtocolUtil;
import de.larsgrefer.sass.embedded.util.SyntaxUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sass.embedded_protocol.EmbeddedSass;

public class SassCompiler
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SassCompiler.class);
    private EmbeddedSass.OutputStyle outputStyle = EmbeddedSass.OutputStyle.EXPANDED;
    private boolean generateSourceMaps = false;
    private final CompilerConnection connection;
    private final Random compileRequestIds = new Random();
    private final Map<String, HostFunction> globalFunctions = new HashMap<String, HostFunction>();
    private final Map<Integer, FileImporter> fileImporters = new HashMap<Integer, FileImporter>();
    private final Map<Integer, CustomImporter> customImporters = new HashMap<Integer, CustomImporter>();
    private LoggingHandler loggingHandler = new Slf4jLoggingHandler(log);
    private List<File> loadPaths = new LinkedList<File>();

    public SassCompiler(CompilerConnection connection) {
        this.connection = connection;
    }

    public EmbeddedSass.OutboundMessage.VersionResponse getVersion() throws IOException {
        return this.exec(ProtocolUtil.inboundMessage(EmbeddedSass.InboundMessage.VersionRequest.getDefaultInstance())).getVersionResponse();
    }

    public void registerFunction(@NonNull HostFunction sassFunction) {
        if (sassFunction == null) {
            throw new IllegalArgumentException("sassFunction is marked non-null but is null");
        }
        this.globalFunctions.put(sassFunction.getName(), sassFunction);
    }

    public void registerImporter(@NonNull FileImporter fileImporter) {
        if (fileImporter == null) {
            throw new IllegalArgumentException("fileImporter is marked non-null but is null");
        }
        this.fileImporters.put(fileImporter.getId(), fileImporter);
    }

    public void registerImporter(@NonNull CustomImporter customImporter) {
        if (customImporter == null) {
            throw new IllegalArgumentException("customImporter is marked non-null but is null");
        }
        this.customImporters.put(customImporter.getId(), customImporter);
    }

    protected EmbeddedSass.InboundMessage.CompileRequest.Builder compileRequestBuilder() {
        EmbeddedSass.InboundMessage.CompileRequest.Importer importer;
        EmbeddedSass.InboundMessage.CompileRequest.Builder builder = EmbeddedSass.InboundMessage.CompileRequest.newBuilder();
        builder.setId(Math.abs(this.compileRequestIds.nextInt()));
        builder.setStyle(this.outputStyle);
        builder.setSourceMap(this.generateSourceMaps);
        for (File file : this.loadPaths) {
            importer = EmbeddedSass.InboundMessage.CompileRequest.Importer.newBuilder().setPath(file.getAbsolutePath()).build();
            builder.addImporters(importer);
        }
        for (Importer importer2 : this.customImporters.values()) {
            importer = EmbeddedSass.InboundMessage.CompileRequest.Importer.newBuilder().setImporterId(importer2.getId()).build();
            builder.addImporters(importer);
        }
        for (Importer importer3 : this.fileImporters.values()) {
            importer = EmbeddedSass.InboundMessage.CompileRequest.Importer.newBuilder().setFileImporterId(importer3.getId()).build();
            builder.addImporters(importer);
        }
        for (HostFunction hostFunction : this.globalFunctions.values()) {
            builder.addGlobalFunctions(hostFunction.getSignature());
        }
        return builder;
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compile(@NonNull URL source) throws SassCompilationFailedException, IOException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compile(source, this.getOutputStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compile(@NonNull URL source, EmbeddedSass.OutputStyle outputStyle) throws SassCompilationFailedException, IOException {
        ByteString content;
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        if (source.getProtocol().equals("file")) {
            File file = new File(source.getPath());
            return this.compileFile(file);
        }
        EmbeddedSass.Syntax syntax = SyntaxUtil.guessSyntax(source);
        try (InputStream in = source.openStream();){
            content = ByteString.readFrom((InputStream)in);
        }
        CustomImporter importer = new RelativeUrlImporter(source).autoCanonicalize();
        this.customImporters.put(importer.getId(), importer);
        EmbeddedSass.InboundMessage.CompileRequest.StringInput build = EmbeddedSass.InboundMessage.CompileRequest.StringInput.newBuilder().setUrl(source.toString()).setSourceBytes(content).setImporter(EmbeddedSass.InboundMessage.CompileRequest.Importer.newBuilder().setImporterId(importer.getId()).build()).setSyntax(syntax).build();
        try {
            EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSuccess = this.compileString(build, outputStyle);
            return compileSuccess;
        }
        finally {
            this.customImporters.remove(importer.getId());
        }
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileScssString(@NonNull @Language(value="SCSS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, EmbeddedSass.Syntax.SCSS);
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSassString(@NonNull @Language(value="SASS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, EmbeddedSass.Syntax.INDENTED);
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileCssString(@NonNull @Language(value="CSS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, EmbeddedSass.Syntax.CSS);
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileString(String source, EmbeddedSass.Syntax syntax) throws SassCompilationFailedException, IOException {
        return this.compileString(source, syntax, this.getOutputStyle());
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileString(@NonNull String source, EmbeddedSass.Syntax syntax, EmbeddedSass.OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        EmbeddedSass.InboundMessage.CompileRequest.StringInput stringInput = EmbeddedSass.InboundMessage.CompileRequest.StringInput.newBuilder().setSource(source).setSyntax(syntax).build();
        return this.compileString(stringInput, outputStyle);
    }

    @Nonnull
    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileString(EmbeddedSass.InboundMessage.CompileRequest.StringInput string, @NonNull EmbeddedSass.OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (outputStyle == null) {
            throw new IllegalArgumentException("outputStyle is marked non-null but is null");
        }
        EmbeddedSass.InboundMessage.CompileRequest compileRequest = this.compileRequestBuilder().setString(string).setStyle(outputStyle).setId(new Random().nextInt()).build();
        return this.execCompileRequest(compileRequest);
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileFile(@NonNull File inputFile) throws IOException, SassCompilationFailedException {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile is marked non-null but is null");
        }
        return this.compileFile(inputFile, this.getOutputStyle());
    }

    public EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileFile(@NonNull File file, @NonNull EmbeddedSass.OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (outputStyle == null) {
            throw new IllegalArgumentException("outputStyle is marked non-null but is null");
        }
        EmbeddedSass.InboundMessage.CompileRequest compileRequest = this.compileRequestBuilder().setPath(file.getPath()).setStyle(outputStyle).build();
        return this.execCompileRequest(compileRequest);
    }

    private EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess execCompileRequest(EmbeddedSass.InboundMessage.CompileRequest compileRequest) throws IOException, SassCompilationFailedException {
        EmbeddedSass.OutboundMessage outboundMessage = this.exec(ProtocolUtil.inboundMessage(compileRequest));
        if (!outboundMessage.hasCompileResponse()) {
            throw new IllegalStateException("No compile response");
        }
        EmbeddedSass.OutboundMessage.CompileResponse compileResponse = outboundMessage.getCompileResponse();
        if (compileResponse.getId() != compileRequest.getId()) {
            throw new IllegalStateException(String.format("Compilation ID mismatch: expected %d, but got %d", compileRequest.getId(), compileResponse.getId()));
        }
        if (compileResponse.hasSuccess()) {
            return compileResponse.getSuccess();
        }
        if (compileResponse.hasFailure()) {
            throw new SassCompilationFailedException(compileResponse.getFailure());
        }
        throw new IllegalStateException("Neither success nor failure");
    }

    private EmbeddedSass.OutboundMessage exec(EmbeddedSass.InboundMessage inboundMessage) throws IOException {
        CompilerConnection compilerConnection = this.connection;
        synchronized (compilerConnection) {
            EmbeddedSass.OutboundMessage outboundMessage;
            this.connection.sendMessage(inboundMessage);
            block13: while (true) {
                outboundMessage = this.connection.readResponse();
                switch (outboundMessage.getMessageCase()) {
                    case ERROR: {
                        throw new SassProtocolErrorException(outboundMessage.getError());
                    }
                    case COMPILE_RESPONSE: 
                    case VERSION_RESPONSE: {
                        return outboundMessage;
                    }
                    case LOG_EVENT: {
                        this.loggingHandler.handle((EmbeddedSass.OutboundMessage.LogEventOrBuilder)outboundMessage.getLogEvent());
                        continue block13;
                    }
                    case CANONICALIZE_REQUEST: {
                        this.handleCanonicalizeRequest(outboundMessage.getCanonicalizeRequest());
                        continue block13;
                    }
                    case IMPORT_REQUEST: {
                        this.handleImportRequest(outboundMessage.getImportRequest());
                        continue block13;
                    }
                    case FILE_IMPORT_REQUEST: {
                        this.handleFileImportRequest(outboundMessage.getFileImportRequest());
                        continue block13;
                    }
                    case FUNCTION_CALL_REQUEST: {
                        this.handleFunctionCallRequest(outboundMessage.getFunctionCallRequest());
                        continue block13;
                    }
                    case MESSAGE_NOT_SET: {
                        throw new IllegalStateException("No message set");
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown OutboundMessage: " + outboundMessage.getMessageCase());
        }
    }

    private void handleFileImportRequest(EmbeddedSass.OutboundMessage.FileImportRequest fileImportRequest) throws IOException {
        EmbeddedSass.InboundMessage.FileImportResponse.Builder fileImportResponse = EmbeddedSass.InboundMessage.FileImportResponse.newBuilder().setId(fileImportRequest.getId());
        FileImporter fileImporter = this.fileImporters.get(fileImportRequest.getImporterId());
        try {
            File file = fileImporter.handleImport(fileImportRequest.getUrl(), fileImportRequest.getFromImport());
            if (file != null) {
                fileImportResponse.setFileUrl(file.toURI().toURL().toString());
            }
        }
        catch (Throwable t) {
            log.debug("Failed to execute FileImportRequest {}", (Object)fileImportRequest, (Object)t);
            fileImportResponse.setError(this.getErrorMessage(t));
        }
        this.connection.sendMessage(ProtocolUtil.inboundMessage(fileImportResponse.build()));
    }

    private void handleImportRequest(EmbeddedSass.OutboundMessage.ImportRequest importRequest) throws IOException {
        EmbeddedSass.InboundMessage.ImportResponse.Builder importResponse = EmbeddedSass.InboundMessage.ImportResponse.newBuilder().setId(importRequest.getId());
        CustomImporter customImporter = this.customImporters.get(importRequest.getImporterId());
        try {
            EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess success = customImporter.handleImport(importRequest.getUrl());
            if (success != null) {
                importResponse.setSuccess(success);
            }
        }
        catch (Throwable t) {
            log.debug("Failed to handle ImportRequest {}", (Object)importRequest, (Object)t);
            importResponse.setError(this.getErrorMessage(t));
        }
        this.connection.sendMessage(ProtocolUtil.inboundMessage(importResponse.build()));
    }

    private void handleCanonicalizeRequest(EmbeddedSass.OutboundMessage.CanonicalizeRequest canonicalizeRequest) throws IOException {
        EmbeddedSass.InboundMessage.CanonicalizeResponse.Builder canonicalizeResponse = EmbeddedSass.InboundMessage.CanonicalizeResponse.newBuilder().setId(canonicalizeRequest.getId());
        CustomImporter customImporter = this.customImporters.get(canonicalizeRequest.getImporterId());
        try {
            String canonicalize = customImporter.canonicalize(canonicalizeRequest.getUrl(), canonicalizeRequest.getFromImport());
            if (canonicalize != null) {
                canonicalizeResponse.setUrl(canonicalize);
            }
        }
        catch (Throwable e) {
            log.debug("Failed to handle CanonicalizeRequest {}", (Object)canonicalizeRequest, (Object)e);
            canonicalizeResponse.setError(this.getErrorMessage(e));
        }
        this.connection.sendMessage(ProtocolUtil.inboundMessage(canonicalizeResponse.build()));
    }

    private void handleFunctionCallRequest(EmbeddedSass.OutboundMessage.FunctionCallRequest functionCallRequest) throws IOException {
        EmbeddedSass.InboundMessage.FunctionCallResponse.Builder response = EmbeddedSass.InboundMessage.FunctionCallResponse.newBuilder().setId(functionCallRequest.getId());
        HostFunction sassFunction = null;
        try {
            switch (functionCallRequest.getIdentifierCase()) {
                case NAME: {
                    sassFunction = this.globalFunctions.get(functionCallRequest.getName());
                    break;
                }
                case FUNCTION_ID: {
                    throw new UnsupportedOperationException("Calling functions by ID is not supported");
                }
                case IDENTIFIER_NOT_SET: {
                    throw new IllegalArgumentException("FunctionCallRequest has no identifier");
                }
            }
            List argumentsList = functionCallRequest.getArgumentsList();
            EmbeddedSass.Value result = sassFunction.invoke(argumentsList);
            response.setSuccess(result);
        }
        catch (Throwable e) {
            log.debug("Failed to handle FunctionCallRequest for function {}", sassFunction, (Object)e);
            response.setError(this.getErrorMessage(e));
        }
        this.connection.sendMessage(ProtocolUtil.inboundMessage(response.build()));
    }

    private String getErrorMessage(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Generated
    public EmbeddedSass.OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public void setOutputStyle(EmbeddedSass.OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    @Generated
    public boolean isGenerateSourceMaps() {
        return this.generateSourceMaps;
    }

    @Generated
    public void setGenerateSourceMaps(boolean generateSourceMaps) {
        this.generateSourceMaps = generateSourceMaps;
    }

    @Generated
    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Generated
    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    @Generated
    public List<File> getLoadPaths() {
        return this.loadPaths;
    }

    @Generated
    public void setLoadPaths(List<File> loadPaths) {
        this.loadPaths = loadPaths;
    }
}

