/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.test;

import de.larssh.utils.test.AssertEqualsAndHashCodeArguments;
import de.larssh.utils.test.AssertionException;
import de.larssh.utils.test.Reflects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.jooq.lambda.function.Consumer3;
import org.joor.Reflect;

public final class Assertions {
    public static void assertEqualsAndHashCode(Class<?> clazz, AssertEqualsAndHashCodeArguments arguments) {
        Reflect reflect = Reflect.onClass(clazz);
        Assertions.assertEqualsAndHashCode((Object[] a) -> Reflects.create(reflect, a).get(), arguments);
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"}, justification="need to call constructor twice to validate equals")
    public static void assertEqualsAndHashCode(Function<Object[], ?> constructor, AssertEqualsAndHashCodeArguments arguments) {
        Function<Object[], ?> wrappedConstructor = Assertions.wrapConstructorExceptions(constructor);
        Object object = wrappedConstructor.apply(arguments.getOriginal().toArray());
        int hashCode = object.hashCode();
        org.junit.jupiter.api.Assertions.assertNotEquals(null, object, (String)"equals null");
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)Boolean.TRUE, object, (String)"equals true");
        org.junit.jupiter.api.Assertions.assertEquals(object, object, (String)"equals this");
        Object sameObject = wrappedConstructor.apply(arguments.getOriginal().toArray());
        org.junit.jupiter.api.Assertions.assertEquals(object, sameObject, (String)"equals original arguments");
        org.junit.jupiter.api.Assertions.assertEquals((int)hashCode, (int)sameObject.hashCode(), (String)"hashCode original arguments");
        IntStream.range(0, arguments.getOriginal().size()).forEach(index -> {
            Consumer3 consumer = arguments.isExpectEquality(index) ? org.junit.jupiter.api.Assertions::assertEquals : org.junit.jupiter.api.Assertions::assertNotEquals;
            Object newObject = wrappedConstructor.apply(arguments.getChangedArguments(index).toArray());
            Supplier<String> equalsMessage = () -> String.format("%sequals changed argument %d", arguments.isExpectEquality(index) ? "" : "not ", index + 1);
            consumer.accept(object, newObject, equalsMessage);
            Supplier<String> hashCodeMessage = () -> String.format("hashCode changed argument %d", index + 1);
            consumer.accept((Object)hashCode, (Object)newObject.hashCode(), hashCodeMessage);
        });
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="throw AssertionException instead")
    private static <T> Function<Object[], T> wrapConstructorExceptions(Function<Object[], T> constructor) {
        return arguments -> {
            try {
                return constructor.apply((Object[])arguments);
            }
            catch (Exception e) {
                throw new AssertionException(e, Arrays.stream(arguments).map(Object::toString).collect(Collectors.joining("], [", "Failed constructing using [", "]")));
            }
        };
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Assertions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

