/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.json.dom.values;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.larssh.json.dom.JsonDomDocument;
import de.larssh.json.dom.values.JacksonDomValue;
import de.larssh.json.dom.values.JsonDomValue;
import de.larssh.utils.io.Resources;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;

public class JacksonDomValueTest {
    @Test
    public void shouldReturnXml_whenConvertJsonToXml_givenJson() throws Exception {
        String json = new String(Files.readAllBytes((Path)Resources.getResourceRelativeTo(this.getClass(), (Path)Paths.get("data.json", new String[0])).get()), StandardCharsets.UTF_8);
        String expectedXml = new String(Files.readAllBytes((Path)Resources.getResourceRelativeTo(this.getClass(), (Path)Paths.get("data.xml", new String[0])).get()), StandardCharsets.UTF_8);
        JsonNode jsonNode = new ObjectMapper().readTree(json);
        JsonDomDocument document = new JsonDomDocument((JsonDomValue)new JacksonDomValue(jsonNode));
        StringWriter writer = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource((Node)document), new StreamResult(writer));
        String actualXml = ((Object)writer).toString();
        Assertions.assertThat((String)actualXml).isEqualTo(expectedXml);
    }
}

