// Generated by delombok at Wed Mar 20 16:38:48 UTC 2024
package de.larssh.json.dom;

import static java.util.Collections.emptyList;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import de.larssh.utils.Nullables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

/**
 * JSON DOM implementation of {@link Text}.
 *
 * @param <T> implementation specific JSON element type
 */
public class JsonDomText<T> extends JsonDomNode<T> implements Text {
	/**
	 * The text data
	 *
	 * @return data
	 */
	private final String data;

	/**
	 * Constructor of {@link JsonDomText}.
	 *
	 * @param parentNode parent node
	 * @param data       data
	 */
	public JsonDomText(final JsonDomElement<T> parentNode, final String data) {
		super(parentNode, "#text");
		this.data = data;
	}

	/**
	 * {@inheritDoc}
	 */
	@Nullable
	@Override
	@SuppressWarnings("PMD.ReturnEmptyCollectionRatherThanNull")
	public JsonDomNamedNodeMap<JsonDomAttribute<T>> getAttributes() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public JsonDomNodeList<JsonDomNode<T>> getChildNodes() {
		return new JsonDomNodeList<>(emptyList());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public T getJsonElement() {
		return Nullables.orElseThrow(getParentNode()).getJsonElement();
	}

	/**
	 * {@inheritDoc}
	 */
	@Nullable
	@Override
	public JsonDomText<T> getNextSibling() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public short getNodeType() {
		return Node.TEXT_NODE;
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String getNodeValue() {
		return getData();
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public JsonDomDocument<T> getOwnerDocument() {
		return Nullables.orElseThrow(getParentNode()).getOwnerDocument();
	}

	/**
	 * {@inheritDoc}
	 */
	@Nullable
	@Override
	public JsonDomText<T> getPreviousSibling() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String getTextContent() {
		return getData();
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String getData() {
		return data;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setData(@Nullable @SuppressWarnings("unused") final String data) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getLength() {
		return getData().length();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String substringData(final int offset, final int count) {
		return getData().substring(offset, offset + count);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void appendData(@Nullable @SuppressWarnings("unused") final String data) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void insertData(@SuppressWarnings("unused") final int offset, @Nullable @SuppressWarnings("unused") final String data) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void deleteData(@SuppressWarnings("unused") final int offset, @SuppressWarnings("unused") final int count) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void replaceData(@SuppressWarnings("unused") final int offset, @SuppressWarnings("unused") final int count, @Nullable @SuppressWarnings("unused") final String data) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Text splitText(@SuppressWarnings("unused") final int offset) {
		throw new JsonDomNotSupportedException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isElementContentWhitespace() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWholeText() {
		return getData();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Text replaceWholeText(@Nullable @SuppressWarnings("unused") final String content) {
		throw new JsonDomNotSupportedException();
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public boolean equals(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof JsonDomText)) return false;
		final JsonDomText<?> other = (JsonDomText<?>) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$data = this.getData();
		final java.lang.Object other$data = other.getData();
		if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	protected boolean canEqual(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object other) {
		return other instanceof JsonDomText;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public int hashCode() {
		final int PRIME = 59;
		int result = super.hashCode();
		final java.lang.Object $data = this.getData();
		result = result * PRIME + ($data == null ? 43 : $data.hashCode());
		return result;
	}
}
