// Generated by delombok at Wed Mar 20 14:54:24 UTC 2024
package de.larssh.json.dom.values;

import java.util.Collections;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonValue.ValueType;
import org.w3c.dom.DOMException;
import de.larssh.json.dom.JsonDomType;
import de.larssh.json.dom.children.JsonDomArrayChildren;
import de.larssh.json.dom.children.JsonDomChildren;
import de.larssh.json.dom.children.JsonDomObjectChildren;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

/**
 * Implementation of {@link JsonDomValue} for JSON Processing (aka
 * <a href="https://jcp.org/en/jsr/detail?id=374">JSR-374</a>) and its
 * {@link JsonValue}.
 */
public class JsonProcessingDomValue implements JsonDomValue<JsonValue> {
	/**
	 * Wrapped JSON element
	 */
	private final JsonValue jsonElement;

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public JsonDomChildren<JsonProcessingDomValue> getChildren() {
		final JsonValue value = getJsonElement();
		final ValueType valueType = value.getValueType();
		if (valueType == ValueType.ARRAY) {
			final JsonArray array = value.asJsonArray();
			return new JsonDomArrayChildren<>(array.size(), array, JsonProcessingDomValue::new);
		}
		if (valueType == ValueType.OBJECT) {
			return new JsonDomObjectChildren<>(value.asJsonObject(), JsonProcessingDomValue::new);
		}
		return Collections::emptySet;
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String getTextValue() {
		final JsonValue value = getJsonElement();
		return value.getValueType() == ValueType.STRING ? ((JsonString) value).getString() : value.toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	@SuppressFBWarnings(value = "WEM_WEAK_EXCEPTION_MESSAGING", justification = "there is no more information about valueType")
	public JsonDomType getType() {
		final ValueType valueType = getJsonElement().getValueType();
		if (valueType == ValueType.ARRAY) {
			return JsonDomType.ARRAY;
		}
		if (valueType == ValueType.FALSE || valueType == ValueType.TRUE) {
			return JsonDomType.BOOLEAN;
		}
		if (valueType == ValueType.NULL) {
			return JsonDomType.NULL;
		}
		if (valueType == ValueType.NUMBER) {
			return JsonDomType.NUMBER;
		}
		if (valueType == ValueType.OBJECT) {
			return JsonDomType.OBJECT;
		}
		if (valueType == ValueType.STRING) {
			return JsonDomType.STRING;
		}
		throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "Unknown JSON node type.");
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String toString() {
		return getJsonElement().toString();
	}

	/**
	 * Wrapped JSON element
	 *
	 * @return wrapped JSON element
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public JsonValue getJsonElement() {
		return this.jsonElement;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public JsonProcessingDomValue(final JsonValue jsonElement) {
		this.jsonElement = jsonElement;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public boolean equals(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof JsonProcessingDomValue)) return false;
		final JsonProcessingDomValue other = (JsonProcessingDomValue) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		final java.lang.Object this$jsonElement = this.getJsonElement();
		final java.lang.Object other$jsonElement = other.getJsonElement();
		if (this$jsonElement == null ? other$jsonElement != null : !this$jsonElement.equals(other$jsonElement)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	protected boolean canEqual(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object other) {
		return other instanceof JsonProcessingDomValue;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final java.lang.Object $jsonElement = this.getJsonElement();
		result = result * PRIME + ($jsonElement == null ? 43 : $jsonElement.hashCode());
		return result;
	}
}
