// Generated by delombok at Wed Mar 20 14:54:24 UTC 2024
package de.larssh.json.dom.values;

import java.util.Collections;
import org.w3c.dom.DOMException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import de.larssh.json.dom.JsonDomType;
import de.larssh.json.dom.children.JsonDomArrayChildren;
import de.larssh.json.dom.children.JsonDomChildren;
import de.larssh.json.dom.children.JsonDomObjectChildren;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

/**
 * Implementation of {@link JsonDomValue} for
 * <a href="https://github.com/FasterXML/jackson">Jackson</a> and its
 * {@link JsonNode}.
 */
public class JacksonDomValue implements JsonDomValue<JsonNode> {
	/**
	 * Wrapped JSON element
	 */
	private final JsonNode jsonElement;

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public JsonDomChildren<JacksonDomValue> getChildren() {
		final JsonNode node = getJsonElement();
		if (node.isArray()) {
			return new JsonDomArrayChildren<>(node.size(), node, JacksonDomValue::new);
		}
		if (node.isObject()) {
			return new JsonDomObjectChildren<>(node.fields(), JacksonDomValue::new);
		}
		return Collections::emptySet;
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String getTextValue() {
		final JsonNode node = getJsonElement();
		return node.isTextual() ? node.asText() : node.toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	@SuppressFBWarnings(value = "WEM_WEAK_EXCEPTION_MESSAGING", justification = "there is no more information about nodeType")
	public JsonDomType getType() {
		final JsonNodeType nodeType = getJsonElement().getNodeType();
		if (nodeType == JsonNodeType.ARRAY) {
			return JsonDomType.ARRAY;
		}
		if (nodeType == JsonNodeType.BOOLEAN) {
			return JsonDomType.BOOLEAN;
		}
		if (nodeType == JsonNodeType.NULL) {
			return JsonDomType.NULL;
		}
		if (nodeType == JsonNodeType.NUMBER) {
			return JsonDomType.NUMBER;
		}
		if (nodeType == JsonNodeType.OBJECT) {
			return JsonDomType.OBJECT;
		}
		if (nodeType == JsonNodeType.STRING) {
			return JsonDomType.STRING;
		}
		throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "Unknown JSON node type.");
	}

	/**
	 * {@inheritDoc}
	 */
	@NonNull
	@Override
	public String toString() {
		return getJsonElement().toString();
	}

	/**
	 * Wrapped JSON element
	 *
	 * @return wrapped JSON element
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public JsonNode getJsonElement() {
		return this.jsonElement;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public JacksonDomValue(final JsonNode jsonElement) {
		this.jsonElement = jsonElement;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public boolean equals(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof JacksonDomValue)) return false;
		final JacksonDomValue other = (JacksonDomValue) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		final java.lang.Object this$jsonElement = this.getJsonElement();
		final java.lang.Object other$jsonElement = other.getJsonElement();
		if (this$jsonElement == null ? other$jsonElement != null : !this$jsonElement.equals(other$jsonElement)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	protected boolean canEqual(@edu.umd.cs.findbugs.annotations.Nullable final java.lang.Object other) {
		return other instanceof JacksonDomValue;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final java.lang.Object $jsonElement = this.getJsonElement();
		result = result * PRIME + ($jsonElement == null ? 43 : $jsonElement.hashCode());
		return result;
	}
}
