// Generated by delombok at Wed Mar 20 14:54:24 UTC 2024
package de.larssh.json.dom;

import static java.util.stream.Collectors.toList;
import java.util.List;
import java.util.Optional;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import de.larssh.json.dom.values.JsonDomValue;
import de.larssh.utils.dom.XPathExpressions;

/**
 * This class contains JSON DOM related helper methods for
 * {@link XPathExpression}.
 */
public final class JsonDomXPathExpressions {
	/**
	 * Evaluates the compiled XPath expression in the specified context and
	 * optionally returns a JSON element.
	 *
	 * <p>
	 * See the README.md file for a description of the JSON DOM hierarchy.
	 *
	 * @param <T>          implementation specific JSON element type
	 * @param jsonDomValue the starting context
	 * @param expression   the XPath expression
	 * @return evaluation result as optional {@code T}
	 * @throws XPathExpressionException If the expression cannot be evaluated.
	 */
	public static <T> Optional<T> getJsonElement(final JsonDomValue<T> jsonDomValue, final XPathExpression expression) throws XPathExpressionException {
		return XPathExpressions.<JsonDomNode<T>>getNode(new JsonDomDocument<>(jsonDomValue), expression).map(JsonDomNode::getJsonElement);
	}

	/**
	 * Evaluates the compiled XPath expression in the specified context and returns
	 * a list of JSON elements.
	 *
	 * <p>
	 * See the README.md file for a description of the JSON DOM hierarchy.
	 *
	 * @param <T>          implementation specific JSON element type
	 * @param jsonDomValue the starting context
	 * @param expression   the XPath expression
	 * @return evaluation result as list of {@code T}
	 * @throws XPathExpressionException If the expression cannot be evaluated.
	 */
	public static <T> List<T> getJsonElementList(final JsonDomValue<T> jsonDomValue, final XPathExpression expression) throws XPathExpressionException {
		return XPathExpressions.<JsonDomNode<T>>getNodes(new JsonDomDocument<>(jsonDomValue), expression).stream().map(JsonDomNode::getJsonElement).collect(toList());
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	private JsonDomXPathExpressions() {
		throw new java.lang.UnsupportedOperationException("This is a utility class and cannot be instantiated");
	}
}
