/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.jes.parser;

import de.larssh.jes.Job;
import de.larssh.jes.JobFlag;
import de.larssh.jes.JobOutput;
import de.larssh.jes.JobStatus;
import de.larssh.jes.parser.JesFtpFile;
import de.larssh.jes.parser.JesFtpFileEntryParserException;
import de.larssh.utils.Nullables;
import de.larssh.utils.Optionals;
import de.larssh.utils.text.Patterns;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class JesFtpFileEntryParser
implements FTPFileEntryParser {
    private static final Pattern PATTERN_TITLE = Pattern.compile("^JOBNAME +JOBID +OWNER +STATUS +CLASS *$");
    private static final Pattern PATTERN_JOB = Pattern.compile("^(?<name>[^ ]+) +(?<id>[^ ]+) +(?<owner>[^ ]+) +(?<status>(INPUT|ACTIVE|OUTPUT)) +(?<class>[^ ]+)( +(?<rest>.*))?$");
    private static final Pattern PATTERN_JOB_ABEND = Pattern.compile("ABEND=(?<abend>\\S+)");
    private static final Pattern PATTERN_JOB_RETURN_CODE = Pattern.compile("RC=(?<returnCode>\\d+)");
    private static final Pattern PATTERN_SEPARATOR = Pattern.compile("^-+ *$");
    private static final Pattern PATTERN_SUB_TITLE = Pattern.compile("^ {9}ID  STEPNAME PROCSTEP C DDNAME   (BYTE|REC)-COUNT( COMMENT)? *$");
    private static final Pattern PATTERN_JOB_OUTPUT = Pattern.compile("^ {9}(?<index>\\d{3}) (?<step>.{8}) (?<procedureStep>.{8}) (?<class>.) (?<name>.{8}) +(?<length>\\d+) *$");
    private static final Pattern PATTERN_SPOOL_FILES = Pattern.compile("^\\d+ spool files *$");

    private Job createJob(String line) {
        Matcher matcher = (Matcher)Patterns.matches((Pattern)PATTERN_JOB, (CharSequence)line).orElseThrow(() -> new JesFtpFileEntryParserException("Expected [%s] as job details line, got [%s].", PATTERN_JOB.pattern(), line));
        String jobId = matcher.group("id");
        String name = matcher.group("name");
        JobStatus status = JobStatus.valueOf(matcher.group("status"));
        String owner = matcher.group("owner");
        Optional jesClass = Optionals.ofNonBlank((String)matcher.group("class"));
        Optional rest = Optionals.ofNonBlank((String)matcher.group("rest"));
        OptionalInt resultCode = Optionals.mapToInt(rest.flatMap(r -> Patterns.find((Pattern)PATTERN_JOB_RETURN_CODE, (CharSequence)r)).map(m -> m.group("returnCode")), Integer::parseInt);
        Optional<String> abendCode = rest.flatMap(r -> Patterns.find((Pattern)PATTERN_JOB_ABEND, (CharSequence)r)).map(m -> m.group("abend"));
        List<JobFlag> flags = Arrays.stream(JobFlag.values()).filter(flag -> rest.map(r -> Patterns.find((Pattern)flag.getRestPattern(), (CharSequence)r).isPresent()).orElse(Boolean.FALSE)).collect(Collectors.toList());
        return new Job(jobId, name, status, owner, jesClass, resultCode, abendCode, flags.toArray(new JobFlag[0]));
    }

    private Job createJobAndOutputs(String listEntry) {
        String spoolFiles;
        ArrayList<String> lines = new ArrayList<String>(Strings.getLines((String)listEntry));
        if (lines.isEmpty()) {
            lines.add("");
        }
        Job job = this.createJob((String)lines.remove(0));
        if (!lines.isEmpty() && Strings.matches((CharSequence)((CharSequence)lines.get(0)), (Pattern)PATTERN_SEPARATOR)) {
            lines.remove(0);
        }
        if (lines.isEmpty()) {
            return job;
        }
        String subTitle = (String)lines.remove(0);
        if (!Strings.matches((CharSequence)subTitle, (Pattern)PATTERN_SUB_TITLE)) {
            throw new JesFtpFileEntryParserException("Expected [%s] as sub title line, got [%s].", PATTERN_SUB_TITLE.pattern(), subTitle);
        }
        if (!lines.isEmpty() && Strings.matches((CharSequence)(spoolFiles = (String)lines.get(lines.size() - 1)), (Pattern)PATTERN_SPOOL_FILES)) {
            lines.remove(lines.size() - 1);
        }
        for (String line : lines) {
            this.createJobOutput(job, line);
        }
        return job;
    }

    private JobOutput createJobOutput(Job job, String line) {
        Matcher matcher = (Matcher)Patterns.matches((Pattern)PATTERN_JOB_OUTPUT, (CharSequence)line).orElseThrow(() -> new JesFtpFileEntryParserException("Expected [%s] as job output details line, got [%s].", PATTERN_JOB_OUTPUT.pattern(), line));
        int index = Integer.parseInt(matcher.group("index"));
        String name = matcher.group("name");
        int length = Integer.parseInt(matcher.group("length"));
        Optional step = Optionals.ofNonBlank((String)matcher.group("step"));
        Optional procedureStep = Optionals.ofNonBlank((String)matcher.group("procedureStep"));
        Optional jesClass = Optionals.ofNonBlank((String)matcher.group("class"));
        return job.createOutput(index, name, length, step, procedureStep, jesClass);
    }

    @Nullable
    public JesFtpFile parseFTPEntry(@Nullable String listEntryNullable) {
        String listEntry = (String)Nullables.orElseThrow((Object)listEntryNullable);
        return new JesFtpFile(this.createJobAndOutputs(listEntry), listEntry);
    }

    @Nullable
    public String readNextEntry(@Nullable BufferedReader reader) throws IOException {
        return ((BufferedReader)Nullables.orElseThrow((Object)reader)).readLine();
    }

    @NonNull
    @SuppressFBWarnings(value={"CFS_CONFUSING_FUNCTION_SEMANTICS"}, justification="returning input variable as required by interface contract")
    public List<String> preParse(@Nullable List<String> originalNullable) {
        List original = (List)Nullables.orElseThrow(originalNullable);
        if (original.isEmpty()) {
            throw new JesFtpFileEntryParserException("Parsing JES job details failed. No line found.", new Object[0]);
        }
        if (!Strings.matches((CharSequence)((CharSequence)original.get(0)), (Pattern)PATTERN_TITLE)) {
            throw new JesFtpFileEntryParserException("Parsing JES job details failed. Unexpected first line: [%s].", original.get(0));
        }
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList linesOfCurrentJob = new ArrayList();
        int size = original.size();
        for (int index = 1; index <= size; ++index) {
            boolean isLast;
            boolean bl = isLast = index >= size;
            if ((isLast || Patterns.matches((Pattern)PATTERN_JOB, (CharSequence)((CharSequence)original.get(index))).isPresent()) && !linesOfCurrentJob.isEmpty()) {
                lines.add(String.join((CharSequence)Strings.NEW_LINE, linesOfCurrentJob));
                linesOfCurrentJob.clear();
            }
            if (isLast) continue;
            linesOfCurrentJob.add(original.get(index));
        }
        original.clear();
        original.addAll(lines);
        return original;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JesFtpFileEntryParser() {
    }
}

