/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.maven.jarrunner;

import de.larssh.utils.Finals;
import de.larssh.utils.Optionals;
import de.larssh.utils.SneakyException;
import de.larssh.utils.text.Patterns;
import de.larssh.utils.text.StringConverters;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class Parameters {
    private static final String REPOSITORY_ID_FORMAT_DEFAULT = (String)Finals.constant((Object)"argument-%d");
    private static final String REPOSITORY_LAYOUT_DEFAULT = (String)Finals.constant((Object)"default");
    private static final Pattern REPOSITORY_USER_INFO_PATTERN = Pattern.compile("^(?<userName>.*?)(:(?<converter>base64|plain):(?<password>.*))?$");
    private final List<String> arguments;
    private final Artifact artifact;
    private final Optional<String> classPathFormat;
    private final boolean ignoreSystemRepositories;
    private final Optional<Path> javaPath;
    private final List<String> javaOptions;
    private final Optional<String> mainClass;
    private final MavenSession mavenSession;
    private final List<RemoteRepository> repositories;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final Optional<Path> workingDirectory;

    private static List<RemoteRepository> getRepositories(@Nullable List<String> uris) {
        if (uris == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(uris.size());
        int size = uris.size();
        for (int index = 0; index < size; ++index) {
            repositories.add(Parameters.getRepository(URI.create(uris.get(index)), index));
        }
        return Collections.unmodifiableList(repositories);
    }

    private static RemoteRepository getRepository(URI uri, int index) {
        String id = Strings.isBlank((CharSequence)uri.getFragment()) ? Strings.format((String)REPOSITORY_ID_FORMAT_DEFAULT, (Object[])new Object[]{index + 1}) : uri.getFragment();
        return new RemoteRepository.Builder(id, REPOSITORY_LAYOUT_DEFAULT, Parameters.getRepositoryUrl(uri)).setAuthentication(Parameters.getRepositoryAuthentication(uri)).build();
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exceptions that must not be thrown")
    private static String getRepositoryUrl(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
        }
        catch (URISyntaxException e) {
            throw new SneakyException((Throwable)e);
        }
    }

    @Nullable
    private static Authentication getRepositoryAuthentication(URI uri) {
        if (Strings.isBlank((CharSequence)uri.getUserInfo())) {
            return null;
        }
        Matcher matcher = (Matcher)Patterns.matches((Pattern)REPOSITORY_USER_INFO_PATTERN, (CharSequence)uri.getUserInfo()).orElseThrow(() -> new IllegalArgumentException(Strings.format((String)"The user information part \"%s\" does not match the expected format.", (Object[])new Object[]{uri.getUserInfo()})));
        String userName = matcher.group("userName");
        String password = RepositoryPasswordConverter.convert(matcher.group("converter"), matcher.group("password"));
        return new AuthenticationBuilder().addUsername(userName).addPassword(password).build();
    }

    public Parameters(MavenSession mavenSession, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, @Nullable String artifact, @Nullable String mainClass, @Nullable List<String> arguments, @Nullable String classPathFormat, @Nullable String javaPath, @Nullable List<String> javaOptions, @Nullable List<String> repositories, boolean ignoreSystemRepositories, @Nullable String workingDirectory) {
        this.mavenSession = mavenSession;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.artifact = new DefaultArtifact(artifact);
        this.classPathFormat = Optionals.ofNonBlank((String)classPathFormat);
        this.mainClass = Optionals.ofNonBlank((String)mainClass);
        this.arguments = arguments == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(arguments));
        this.javaPath = Optionals.ofNonBlank((String)javaPath).map(x$0 -> Paths.get(x$0, new String[0]));
        this.javaOptions = javaOptions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(javaOptions));
        this.repositories = Parameters.getRepositories(repositories);
        this.ignoreSystemRepositories = ignoreSystemRepositories;
        this.workingDirectory = Optionals.ofNonBlank((String)workingDirectory).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getArguments() {
        return this.arguments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Artifact getArtifact() {
        return this.artifact;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getClassPathFormat() {
        return this.classPathFormat;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isIgnoreSystemRepositories() {
        return this.ignoreSystemRepositories;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Path> getJavaPath() {
        return this.javaPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getJavaOptions() {
        return this.javaOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getMainClass() {
        return this.mainClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepositorySystemSession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Path> getWorkingDirectory() {
        return this.workingDirectory;
    }

    private static enum RepositoryPasswordConverter {
        BASE64(StringConverters::decodeBase64Url),
        PLAIN(Function.identity());

        private final Function<String, String> converter;

        @Nullable
        public static String convert(@Nullable String converterName, @Nullable String password) {
            if (Strings.isBlank((CharSequence)password)) {
                return null;
            }
            for (RepositoryPasswordConverter converter : RepositoryPasswordConverter.values()) {
                if (!converter.name().equalsIgnoreCase(converterName)) continue;
                return converter.getConverter().apply(password);
            }
            throw new IllegalArgumentException(Strings.format((String)"Unknown password converter given. Allowed values: \"base64\" or \"plain\". Given: \"%s\"", (Object[])new Object[]{converterName}));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Function<String, String> getConverter() {
            return this.converter;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RepositoryPasswordConverter(Function<String, String> converter) {
            this.converter = converter;
        }
    }
}

