/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.maven.jarrunner;

import de.larssh.utils.Optionals;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

class Parameters {
    private final List<String> arguments;
    private final Artifact artifact;
    private final Optional<String> classPathFormat;
    private final Optional<Path> javaPath;
    private final List<String> javaOptions;
    private final Optional<String> mainClass;
    private final MavenSession mavenSession;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final Optional<Path> workingDirectory;

    public Parameters(MavenSession mavenSession, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, @Nullable String artifact, @Nullable String mainClass, @Nullable List<String> arguments, @Nullable String classPathFormat, @Nullable String javaPath, @Nullable List<String> javaOptions, @Nullable String workingDirectory) {
        this.mavenSession = mavenSession;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.artifact = new DefaultArtifact(artifact);
        this.classPathFormat = Optionals.ofNonBlank((String)classPathFormat);
        this.mainClass = Optionals.ofNonBlank((String)mainClass);
        this.arguments = arguments == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(arguments));
        this.javaPath = Optionals.ofNonBlank((String)javaPath).map(x$0 -> Paths.get(x$0, new String[0]));
        this.javaOptions = javaOptions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(javaOptions));
        this.workingDirectory = Optionals.ofNonBlank((String)workingDirectory).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getArguments() {
        return this.arguments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Artifact getArtifact() {
        return this.artifact;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getClassPathFormat() {
        return this.classPathFormat;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Path> getJavaPath() {
        return this.javaPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getJavaOptions() {
        return this.javaOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getMainClass() {
        return this.mainClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepositorySystemSession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Path> getWorkingDirectory() {
        return this.workingDirectory;
    }
}

