/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.maven.jarrunner;

import de.larssh.maven.jarrunner.Parameters;
import de.larssh.utils.AetherUtils;
import de.larssh.utils.SystemUtils;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

class JarRunner {
    private final Parameters parameters;

    public void run() throws DependencyResolutionException, IOException, MojoFailureException {
        DependencyResult dependencyResult = this.resolveDependencies();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaExecutable());
        commands.addAll(this.getParameters().getJavaOptions());
        commands.add("-classpath");
        commands.add(this.getClassPath(dependencyResult));
        commands.add(this.getMainClass(dependencyResult));
        commands.addAll(this.getParameters().getArguments());
        ProcessBuilder builder = new ProcessBuilder(commands.toArray(new String[0])).inheritIO();
        this.getParameters().getWorkingDirectory().map(Path::toFile).ifPresent(builder::directory);
        int exitValue = this.waitForWithoutInterrupting(builder.start());
        if (exitValue != 0) {
            throw new MojoFailureException(Strings.format((String)"Application stopped with exit value %d.", (Object[])new Object[]{exitValue}));
        }
    }

    private String getClassPath(DependencyResult dependencyResult) {
        String classPath = AetherUtils.getClassPath((DependencyResult)dependencyResult);
        return this.getParameters().getClassPathFormat().map(format -> String.format(format, classPath)).orElse(classPath);
    }

    private String getJavaExecutable() {
        Optional<Path> javaPath = this.getParameters().getJavaPath();
        if (javaPath.isPresent()) {
            return javaPath.get().toString();
        }
        return SystemUtils.getJavaExecutable().toString();
    }

    private String getMainClass(DependencyResult dependencyResult) throws IOException, MojoFailureException {
        Optional<String> optionalMainClass = this.getParameters().getMainClass();
        if (optionalMainClass.isPresent()) {
            return optionalMainClass.get();
        }
        File jarFile = dependencyResult.getRoot().getArtifact().getFile();
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));){
            String mainClass = jarInputStream.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (!Strings.isBlank((CharSequence)mainClass)) {
                String string = mainClass;
                return string;
            }
        }
        throw new MojoFailureException(Strings.format((String)"Could not find a %s entry inside the root JARs [%s] manifest. You can provide a main class yourself using -DmainClass=...", (Object[])new Object[]{Attributes.Name.MAIN_CLASS.toString(), jarFile.getAbsolutePath()}));
    }

    private DependencyResult resolveDependencies() throws DependencyResolutionException {
        Parameters p = this.getParameters();
        CollectRequest collectRequest = new CollectRequest(new Dependency(p.getArtifact(), "compile"), AetherUtils.getRemoteRepositories((MavenSession)p.getMavenSession()));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (DependencyFilter)new ScopeDependencyFilter(Arrays.asList("compile", "runtime"), null));
        return p.getRepositorySystem().resolveDependencies(p.getRepositorySystemSession(), dependencyRequest);
    }

    private int waitForWithoutInterrupting(Process process) {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            return this.waitForWithoutInterrupting(process);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Parameters getParameters() {
        return this.parameters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JarRunner(Parameters parameters) {
        this.parameters = parameters;
    }
}

