/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.jsf2.component.showcase;

import de.larmic.jsf2.component.showcase.AbstractShowcaseComponent;
import de.larmic.jsf2.component.showcase.ComboBoxShowcaseComponent;
import de.larmic.jsf2.component.showcase.ComboBoxValueType;
import de.larmic.jsf2.component.showcase.comboBox.Foo;
import de.larmic.jsf2.component.showcase.comboBox.FooConverter;
import de.larmic.jsf2.component.showcase.comboBox.FooType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.faces.model.SelectItem;
import javax.inject.Named;

@Named
@SessionScoped
public class ComboBoxShowcaseComponent
extends AbstractShowcaseComponent
implements Serializable {
    private ComboBoxValueType comboBoxValueType = ComboBoxValueType.STRING;
    private final List<SelectItem> foos = new ArrayList();
    private final List<SelectItem> enums = new ArrayList();
    private final List<SelectItem> strings = new ArrayList();

    public ComboBoxShowcaseComponent() {
        this.initFoos();
        this.initStrings();
        this.initEnums();
    }

    protected Object initValue() {
        return null;
    }

    public Object getValue() {
        if (super.getValue() != null) {
            return super.getValue().toString();
        }
        return "(item is null)";
    }

    public String getReadableValue() {
        if (super.getValue() != null) {
            if (super.getValue() instanceof Foo) {
                return ((Foo)super.getValue()).getValue();
            }
            if (super.getValue() instanceof FooType) {
                return ((FooType)super.getValue()).label;
            }
            return (String)super.getValue();
        }
        return "(item is null)";
    }

    public List<SelectItem> getValues() {
        switch (1.$SwitchMap$de$larmic$jsf2$component$showcase$ComboBoxValueType[this.comboBoxValueType.ordinal()]) {
            case 1: {
                return this.foos;
            }
            case 2: {
                return this.enums;
            }
        }
        return this.strings;
    }

    public String getXHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<l:comboBox id=\"input\"\n");
        sb.append("        \t   label=\"" + this.getLabel() + "\"\n");
        sb.append("        \t   value=\"" + this.getValue() + "\"\n");
        if (this.getTooltip() != null && !"".equals(this.getTooltip())) {
            sb.append("        \t   tooltip=\"" + this.getTooltip() + "\"\n");
        }
        sb.append("        \t   readonly=\"" + this.isReadonly() + "\"\n");
        sb.append("        \t   required=\"" + this.isRequired() + "\"\n");
        sb.append("        \t   floating=\"" + this.isFloating() + "\"\n");
        sb.append("        \t   rendered=\"" + this.isRendered() + "\">\n");
        if (this.comboBoxValueType == ComboBoxValueType.STRING) {
            sb.append("    <f:selectItem itemValue=\"#{null}\" \n");
            sb.append("                  itemLabel=\"Choose one...\"/>\n");
            sb.append("    <f:selectItem itemValue=\"2000\" \n");
            sb.append("                  itemLabel=\"Year 2000\"/>\n");
            sb.append("    <f:selectItem itemValue=\"2010\" \n");
            sb.append("                  itemLabel=\"Year 2010\"/>\n");
            sb.append("    <f:selectItem itemValue=\"2020\" \n");
            sb.append("                  itemLabel=\"Year 2020\"/>\n");
        } else if (this.comboBoxValueType == ComboBoxValueType.ENUM) {
            sb.append("    <f:selectItems value=\"#{bean.fooEnums}\"/>\n");
        } else if (this.comboBoxValueType == ComboBoxValueType.OBJECT) {
            sb.append("    <f:selectItems value=\"#{bean.fooObjects}\"/>\n");
            sb.append("    <f:converter converterId=\"fooConverter\"/>\n");
        }
        this.createAjaxXhtml(sb, "change");
        sb.append("</l:comboBox>");
        this.createOutputXhtml(sb);
        return sb.toString();
    }

    public boolean isConverterActive() {
        return this.comboBoxValueType == ComboBoxValueType.OBJECT;
    }

    public List<SelectItem> getComboBoxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ComboBoxValueType type : ComboBoxValueType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public ComboBoxValueType getComboBoxValueType() {
        return this.comboBoxValueType;
    }

    public void setComboBoxValueType(ComboBoxValueType comboBoxValueType) {
        this.comboBoxValueType = comboBoxValueType;
    }

    private void initFoos() {
        this.foos.add(new SelectItem(null, "Choose one..."));
        for (String key : FooConverter.fooMap.keySet()) {
            Foo foo = (Foo)FooConverter.fooMap.get(key);
            this.foos.add(new SelectItem((Object)foo, foo.getKey()));
        }
    }

    private void initEnums() {
        this.enums.add(new SelectItem(null, "Choose one..."));
        for (FooType fooType : FooType.values()) {
            this.enums.add(new SelectItem((Object)fooType.label));
        }
    }

    private void initStrings() {
        this.strings.add(new SelectItem(null, "Choose one..."));
        this.strings.add(new SelectItem((Object)"2000", "Year 2000"));
        this.strings.add(new SelectItem((Object)"2010", "Year 2010"));
        this.strings.add(new SelectItem((Object)"2020", "Year 2020"));
    }
}

