package de.larmic.jsf2.component.showcase;

import javax.enterprise.context.SessionScoped;
import javax.inject.Named;
import java.io.Serializable;

@Named
@SessionScoped
@SuppressWarnings("serial")
public class SecretShowcaseComponent extends AbstractShowcaseComponent implements Serializable {

	private String placeholder = "enter password";

	@Override
	protected Object initValue() {
		return "value";
	}

	@Override
	public String getReadableValue() {
		return (String) this.getValue();
	}

	@Override
	public String getXHtml() {
		final StringBuilder sb = new StringBuilder();
		sb.append("<l:secret id=\"input\"\n");
		sb.append("        label=\"" + this.getLabel() + "\"\n");
		sb.append("        value=\"" + this.getValue() + "\"\n");
		if (this.getTooltip() != null && !"".equals(this.getTooltip())) {
			sb.append("        tooltip=\"" + this.getTooltip() + "\"\n");
		}
		if (this.getPlaceholder() != null && !"".equals(this.getPlaceholder())) {
			sb.append("        placeholder=\"" + this.getPlaceholder() + "\"\n");
		}
		sb.append("        readonly=\"" + this.isReadonly() + "\"\n");
		sb.append("        required=\"" + this.isRequired() + "\"\n");
		sb.append("        floating=\"" + this.isFloating() + "\"\n");
		sb.append("        rendered=\"" + this.isRendered() + "\">\n");

		this.createAjaxXhtml(sb, "keyup");

		if (this.isValidation()) {
			sb.append("    <f:validateLength minimum=\"2\" maximum=\"10\"/>\n");
		}
		sb.append("</l:secret>");

		this.createOutputXhtml(sb);

		return sb.toString();
	}

	public String getPlaceholder() {
		return this.placeholder;
	}

	public void setPlaceholder(final String placeholder) {
		this.placeholder = placeholder;
	}

}
