/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.joinfaces.test;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class FacesContextMock {
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private Map<String, Object> viewMap = new HashMap<String, Object>();

    public FacesContextMock withExternalParameter(Map<String, String> parameters) {
        this.parameterMap.putAll(parameters);
        return this;
    }

    public FacesContextMock replaceIn(ApplicationContext applicationContext) {
        FacesContext facesContext;
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        if (!beanFactory.containsBean("facesContext")) {
            facesContext = (FacesContext)Mockito.mock(FacesContext.class);
            beanFactory.registerSingleton("facesContext", (Object)facesContext);
        } else {
            facesContext = (FacesContext)beanFactory.getBean("facesContext");
        }
        ExternalContext externalContext = (ExternalContext)Mockito.mock(ExternalContext.class);
        UIViewRoot uiViewRoot = (UIViewRoot)Mockito.mock(UIViewRoot.class);
        Mockito.when((Object)facesContext.getExternalContext()).thenReturn((Object)externalContext);
        Mockito.when((Object)externalContext.getRequestParameterMap()).thenReturn(this.parameterMap);
        Mockito.when((Object)facesContext.getViewRoot()).thenReturn((Object)uiViewRoot);
        Mockito.when((Object)uiViewRoot.getViewMap()).thenReturn(this.viewMap);
        try {
            Field field = FacesContext.class.getDeclaredField("instance");
            field.setAccessible(true);
            ThreadLocal threadLocal = (ThreadLocal)field.get(null);
            threadLocal.set(facesContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

