/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.tree;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.tree.NodeData;
import de.larmic.butterfaces.component.showcase.tree.SelectionAjaxType;
import de.larmic.butterfaces.component.showcase.tree.ShowcaseTreeNode;
import de.larmic.butterfaces.component.showcase.tree.TreeIconType;
import de.larmic.butterfaces.component.showcase.tree.TreeSearchBarModeType;
import de.larmic.butterfaces.component.showcase.tree.TreeShowcase;
import de.larmic.butterfaces.component.showcase.tree.TreeTemplateType;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxWebXmlExample;
import de.larmic.butterfaces.event.TreeNodeExpansionListener;
import de.larmic.butterfaces.event.TreeNodeSelectionEvent;
import de.larmic.butterfaces.event.TreeNodeSelectionListener;
import de.larmic.butterfaces.model.tree.DefaultNodeImpl;
import de.larmic.butterfaces.model.tree.Node;
import de.larmic.butterfaces.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class TreeShowcase
extends AbstractCodeShowcase
implements Serializable,
TreeNodeSelectionListener,
TreeNodeExpansionListener {
    private final ShowcaseTreeNode showcaseTreeNode = new ShowcaseTreeNode();
    private boolean hideRootNode = false;
    private SelectionAjaxType selectionAjaxType = SelectionAjaxType.AJAX;
    private TreeTemplateType selectedTreeTemplateType = TreeTemplateType.DEFAULT;
    private TreeSearchBarModeType selectedSearchBarModeType = TreeSearchBarModeType.ALWAYS_VISIBLE;
    private boolean allExpanded = false;
    private String placeholder = "Search...";
    private Integer toManyVisibleItemsRenderDelay;
    private Integer toManyVisibleItemsThreshold;
    private String noEntriesText;
    private String spinnerText;
    private Node selectedNode;

    public void processValueChange(TreeNodeSelectionEvent event) {
        this.selectedNode = event.getNewValue();
    }

    public boolean isValueSelected(Node data) {
        return this.selectedNode != null && data.getTitle().equals(this.selectedNode.getTitle());
    }

    public void expandNode(Node node) {
    }

    public void collapseNode(Node node) {
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        codeExamples.add((AbstractCodeExample)this.createXhtmlCodeExample());
        codeExamples.add((AbstractCodeExample)this.createMyBeanCodeExample());
        if (this.selectedTreeTemplateType == TreeTemplateType.CUSTOM) {
            codeExamples.add((AbstractCodeExample)this.createNodeDataCodeExample());
        }
        codeExamples.add((AbstractCodeExample)new TreeBoxWebXmlExample());
    }

    private JavaCodeExample createNodeDataCodeExample() {
        JavaCodeExample codeExample = new JavaCodeExample("NodeData.java", "nodeData", "tree.demo", "NodeData", false);
        codeExample.appendInnerContent("    private final UUID uuid = UUID.randomUUID();\n");
        codeExample.appendInnerContent("    private final Date createDate = new Date();\n");
        codeExample.appendInnerContent("    // GETTER");
        return codeExample;
    }

    private JavaCodeExample createMyBeanCodeExample() {
        JavaCodeExample myBean = new JavaCodeExample("MyBean.java", "mybean", "tree.demo", "MyBean", true);
        if (this.selectionAjaxType != SelectionAjaxType.NONE) {
            myBean.addImport("import de.larmic.butterfaces.event.TreeNodeSelectionEvent");
            myBean.addImport("import de.larmic.butterfaces.event.TreeNodeSelectionListener");
        }
        myBean.addImport("import de.larmic.butterfaces.model.tree.Node");
        myBean.addImport("import de.larmic.butterfaces.model.tree.DefaultNodeImpl");
        myBean.addImport("import javax.faces.view.ViewScoped");
        myBean.addImport("import javax.inject.Named");
        if (this.selectionAjaxType != SelectionAjaxType.NONE) {
            myBean.addInterfaces("TreeNodeSelectionListener");
        }
        if (this.isAjaxRendered()) {
            myBean.appendInnerContent("    private Node selectedNode;\n");
        }
        myBean.appendInnerContent("    private Node rootNode;\n");
        myBean.appendInnerContent("    public Node getTreeModel() {");
        myBean.appendInnerContent("        if (rootNode == null) {");
        if (this.selectedTreeTemplateType == TreeTemplateType.CUSTOM) {
            myBean.appendInnerContent("            final Node mailNode = new DefaultNodeImpl(\"Mail\", new NodeData());");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Inbox\", new NodeData()));");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Drafts\", new NodeData()));");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Sent\", new NodeData()));");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Tagged\", new NodeData()));");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Folders\", new NodeData()));");
            myBean.appendInnerContent("            mailNode.getSubNodes().add(new DefaultNodeImpl<>(\"Trash\", new NodeData()));");
            myBean.appendInnerContent("\n");
            myBean.appendInnerContent("            final Node<NodeData> rootNode = new DefaultNodeImpl<>(\"rootNode\", new NodeData());");
            myBean.appendInnerContent("            rootNode.getSubNodes().add(mailNode);");
            myBean.appendInnerContent("            rootNode.getSubNodes().add(new DefaultNodeImpl<>(\"Special Sign \\\"\\'\", new NodeData()));");
            myBean.appendInnerContent("            return rootNode;");
        } else {
            myBean.appendInnerContent("            final Node firstChild = new DefaultNodeImpl(\"firstChild\");");
            myBean.appendInnerContent("            firstChild.setDescription(\"23 unread\");");
            if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.GLYPHICON) {
                myBean.appendInnerContent("            firstChild.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
            } else if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.IMAGE) {
                myBean.appendInnerContent("            firstChild.setImageIcon(\"some/path/16.png\");");
            }
            myBean.appendInnerContent("            final Node secondChild = new DefaultNodeImpl(\"second\");");
            if (!this.allExpanded) {
                myBean.appendInnerContent("            secondChild.setCollapsed(true);");
            }
            if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.GLYPHICON) {
                myBean.appendInnerContent("            secondChild.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
            } else if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.IMAGE) {
                myBean.appendInnerContent("            secondChild.setImageIcon(\"some/path/16.png\");");
            }
            myBean.appendInnerContent("            secondChild.getSubNodes().add(new DefaultNodeImpl(\"...\"))");
            myBean.appendInnerContent("            ...");
            myBean.appendInnerContent("            rootNode = new DefaultNodeImpl(\"rootNode\");");
            if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.IMAGE) {
                myBean.appendInnerContent("            rootNode.setImageIcon(\"some/path/16.png\");");
            } else if (this.showcaseTreeNode.getSelectedIconType() == TreeIconType.GLYPHICON) {
                myBean.appendInnerContent("            rootNode.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
            }
        }
        myBean.appendInnerContent("            rootNode.getSubNodes().add(firstChild);");
        myBean.appendInnerContent("            rootNode.getSubNodes().add(secondChild);");
        myBean.appendInnerContent("        }");
        myBean.appendInnerContent("        return rootNode;");
        myBean.appendInnerContent("    }\n");
        if (this.isAjaxRendered()) {
            myBean.appendInnerContent("    @Override");
            myBean.appendInnerContent("    public void processTableSelection(final TreeNodeSelectionEvent event) {");
            myBean.appendInnerContent("        selectedNode = event.getNewValue();");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    public Node getSelectedNode() {");
            myBean.appendInnerContent("        return selectedNode;");
            myBean.appendInnerContent("    }");
        }
        return myBean;
    }

    public List<SelectItem> getAjaxSelectionTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (SelectionAjaxType type : SelectionAjaxType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getIconTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (TreeIconType type : TreeIconType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getSeachBarModeTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (TreeSearchBarModeType type : TreeSearchBarModeType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    private XhtmlCodeExample createXhtmlCodeExample() {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:tree id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                value=\"#{myBean.treeModel}\"");
        if (this.isAjaxRendered()) {
            xhtmlCodeExample.appendInnerContent("                nodeSelectionListener=\"#{myBean}\"");
        }
        xhtmlCodeExample.appendInnerContent("                hideRootNode=\"" + this.hideRootNode + "\"");
        xhtmlCodeExample.appendInnerContent("                searchBarMode=\"" + this.selectedSearchBarModeType.label + "\"");
        xhtmlCodeExample.appendInnerContent("                placeholder=\"" + this.placeholder + "\"");
        if (StringUtils.isNotEmpty((String)this.spinnerText)) {
            xhtmlCodeExample.appendInnerContent("                spinnerText=\"" + this.spinnerText + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.noEntriesText)) {
            xhtmlCodeExample.appendInnerContent("                noEntriesText=\"" + this.noEntriesText + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                rendered=\"" + this.isRendered() + "\">");
        if (this.selectedTreeTemplateType == TreeTemplateType.CUSTOM) {
            xhtmlCodeExample.appendInnerContent("            <!-- use attributes from node or node.data-->");
            xhtmlCodeExample.appendInnerContent("            <!-- javascript mustache syntax is used -->");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"template\">");
            xhtmlCodeExample.appendInnerContent("                <strong>{{title}}</strong>");
            xhtmlCodeExample.appendInnerContent("                <div>Created: {{createDate}}</div>");
            xhtmlCodeExample.appendInnerContent("                <div>UUID: {{uuid}}</div>");
            xhtmlCodeExample.appendInnerContent("            </facet>");
        }
        if (this.isAjaxRendered()) {
            if (this.isAjaxDisabled()) {
                xhtmlCodeExample.appendInnerContent("            <!-- use toggle to activate selection listener -->");
                xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"click\" render=\"nodeTitle\" disabled=\"true\"/>");
                xhtmlCodeExample.appendInnerContent("            <!-- use toggle to activate expansion listener -->");
                xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"toggle\" render=\"nodeTitle\" disabled=\"true\"/>");
            } else {
                xhtmlCodeExample.appendInnerContent("            <!-- use toggle to activate selection listener -->");
                xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"click\" render=\"nodeTitle\"/>");
                xhtmlCodeExample.appendInnerContent("            <!-- use toggle to activate expansion listener -->");
                xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"toggle\" render=\"nodeTitle\"/>");
            }
        }
        xhtmlCodeExample.appendInnerContent("        </b:tree>");
        if (this.isAjaxRendered()) {
            xhtmlCodeExample.appendInnerContent("\n    <h:panelGroup id=\"nodeTitle\">");
            xhtmlCodeExample.appendInnerContent("            <h:output value=\"#{myBean.selectedNode.title}\"");
            xhtmlCodeExample.appendInnerContent("                      rendered=\"#{not empty myBean.selectedNode}\"/>");
            xhtmlCodeExample.appendInnerContent("    <h:panelGroup/>");
        }
        return xhtmlCodeExample;
    }

    public Object getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$tree$TreeTemplateType[this.selectedTreeTemplateType.ordinal()]) {
            case 1: {
                DefaultNodeImpl mailNode = new DefaultNodeImpl("Mail", (Object)new NodeData());
                mailNode.getSubNodes().add(new DefaultNodeImpl("Inbox", (Object)new NodeData()));
                mailNode.getSubNodes().add(new DefaultNodeImpl("Drafts", (Object)new NodeData()));
                mailNode.getSubNodes().add(new DefaultNodeImpl("Sent", (Object)new NodeData()));
                mailNode.getSubNodes().add(new DefaultNodeImpl("Tagged", (Object)new NodeData()));
                mailNode.getSubNodes().add(new DefaultNodeImpl("Folders", (Object)new NodeData()));
                mailNode.getSubNodes().add(new DefaultNodeImpl("Trash", (Object)new NodeData()));
                DefaultNodeImpl rootNode = new DefaultNodeImpl("rootNode", (Object)new NodeData());
                rootNode.getSubNodes().add(mailNode);
                rootNode.getSubNodes().add(new DefaultNodeImpl("Special Sign \"'", (Object)new NodeData()));
                return rootNode;
            }
        }
        return this.showcaseTreeNode.getTree();
    }

    public List<SelectItem> getTreeTemplateTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (TreeTemplateType type : TreeTemplateType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public boolean isHideRootNode() {
        return this.hideRootNode;
    }

    public void setHideRootNode(boolean hideRootNode) {
        this.hideRootNode = hideRootNode;
    }

    public boolean isAjaxRendered() {
        return SelectionAjaxType.NONE != this.selectionAjaxType;
    }

    public boolean isAjaxDisabled() {
        return SelectionAjaxType.AJAX_DISABLED == this.selectionAjaxType;
    }

    public SelectionAjaxType getSelectionAjaxType() {
        return this.selectionAjaxType;
    }

    public void setSelectionAjaxType(SelectionAjaxType selectionAjaxType) {
        this.selectionAjaxType = selectionAjaxType;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public boolean isAllExpanded() {
        return this.allExpanded;
    }

    public void setAllExpanded(boolean allExpanded) {
        this.allExpanded = allExpanded;
        this.toggleNodeExpansion(this.showcaseTreeNode.getTree(), allExpanded);
    }

    public void toggleNodeExpansion(Node node, boolean expanded) {
        node.setCollapsed(!expanded);
        for (Object subNode : node.getSubNodes()) {
            this.toggleNodeExpansion((Node)subNode, expanded);
        }
    }

    public TreeSearchBarModeType getSelectedSearchBarModeType() {
        return this.selectedSearchBarModeType;
    }

    public void setSelectedSearchBarModeType(TreeSearchBarModeType selectedSearchBarModeType) {
        this.selectedSearchBarModeType = selectedSearchBarModeType;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public TreeTemplateType getSelectedTreeTemplateType() {
        return this.selectedTreeTemplateType;
    }

    public void setSelectedTreeTemplateType(TreeTemplateType selectedTreeTemplateType) {
        this.selectedTreeTemplateType = selectedTreeTemplateType;
    }

    public ShowcaseTreeNode getShowcaseTreeNode() {
        return this.showcaseTreeNode;
    }

    public Integer getToManyVisibleItemsRenderDelay() {
        return this.toManyVisibleItemsRenderDelay;
    }

    public void setToManyVisibleItemsRenderDelay(Integer toManyVisibleItemsRenderDelay) {
        this.toManyVisibleItemsRenderDelay = toManyVisibleItemsRenderDelay;
    }

    public Integer getToManyVisibleItemsThreshold() {
        return this.toManyVisibleItemsThreshold;
    }

    public void setToManyVisibleItemsThreshold(Integer toManyVisibleItemsThreshold) {
        this.toManyVisibleItemsThreshold = toManyVisibleItemsThreshold;
    }

    public String getNoEntriesText() {
        return this.noEntriesText;
    }

    public void setNoEntriesText(String noEntriesText) {
        this.noEntriesText = noEntriesText;
    }

    public String getSpinnerText() {
        return this.spinnerText;
    }

    public void setSpinnerText(String spinnerText) {
        this.spinnerText = spinnerText;
    }
}

