/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.commandLink;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.commandLink.CommandLinkExampleType;
import de.larmic.butterfaces.component.showcase.commandLink.example.CommandLinkWebXmlExample;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class CommandLinkShowcase
extends AbstractCodeShowcase
implements Serializable {
    private String resetValue = "";
    private String value = "click me";
    private String glyphicon = "glyphicon glyphicon-thumbs-up glyphicon-lg";
    private String style = "btn btn-primary";
    private int clicks = 0;
    private boolean ajaxDisableLinkOnRequest = true;
    private boolean ajaxShowWaitingDotsOnRequest = true;
    private boolean ajaxHideGlyphiconOnRequest = false;
    private boolean ajaxDisableRenderRegionsOnRequest = true;
    private String ajaxProcessingText = "Processing";
    private String ajaxProcessingGlyphicon = "fa fa-refresh fa-spin";
    private String render = "clicks disabledOnRequest otherDisabledOnRequest";
    private CommandLinkExampleType commandLinkExampleType = CommandLinkExampleType.AJAX;

    public void increaseClick() {
        System.out.println("action called");
        ++this.clicks;
    }

    public void increaseClickWithDelay() {
        if (this.ajaxDisableLinkOnRequest) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.increaseClick();
    }

    public void actionListener(ActionEvent event) {
        System.out.println("actionlistener called " + event.toString());
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        boolean resetValuesExample = this.commandLinkExampleType != CommandLinkExampleType.RESET_VALUES;
        XhtmlCodeExample xhtmlCodeExample = resetValuesExample ? this.createXhtmlCodeExampleResetValues() : this.createXhtmlCodeExample();
        JavaCodeExample javaCodeExample = resetValuesExample ? this.createJavaCodeExampleResetValues() : this.createJavaCodeExample();
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)javaCodeExample);
        codeExamples.add((AbstractCodeExample)new CommandLinkWebXmlExample());
    }

    private JavaCodeExample createJavaCodeExample() {
        JavaCodeExample javaCodeExample = new JavaCodeExample("MyBean.java", "mybean", "command.link.demo", "MyBean", true);
        javaCodeExample.appendInnerContent("    private String value = \"\";\n");
        javaCodeExample.appendInnerContent("    // getter +  setter");
        return javaCodeExample;
    }

    private JavaCodeExample createJavaCodeExampleResetValues() {
        JavaCodeExample javaCodeExample = new JavaCodeExample("MyBean.java", "mybean", "command.link.demo", "MyBean", true);
        javaCodeExample.appendInnerContent("    private int clicks = 0;\n");
        javaCodeExample.appendInnerContent("    public void increaseClick() {");
        if (this.ajaxDisableLinkOnRequest && this.commandLinkExampleType == CommandLinkExampleType.AJAX) {
            javaCodeExample.appendInnerContent("        try {");
            javaCodeExample.appendInnerContent("            Thread.sleep(2000);");
            javaCodeExample.appendInnerContent("        } catch (InterruptedException e) {");
            javaCodeExample.appendInnerContent("            // this error is not ok...");
            javaCodeExample.appendInnerContent("        }");
        }
        javaCodeExample.appendInnerContent("        clicks++");
        javaCodeExample.appendInnerContent("    }\n");
        javaCodeExample.appendInnerContent("    public int getClicks() {");
        javaCodeExample.appendInnerContent("        return clicks;");
        javaCodeExample.appendInnerContent("    }");
        return javaCodeExample;
    }

    private XhtmlCodeExample createXhtmlCodeExample() {
        boolean useFontAwesome = this.getGlyphicon() != null && this.getGlyphicon().contains("fa");
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(useFontAwesome);
        xhtmlCodeExample.appendInnerContent("\n        <div class=\"row\">");
        xhtmlCodeExample.appendInnerContent("           <h:panelGroup id=\"rerenderArea\"");
        xhtmlCodeExample.appendInnerContent("                         styleClass=\"col-md-10\">");
        xhtmlCodeExample.appendInnerContent("              <b:text label=\"Not null value\"");
        xhtmlCodeExample.appendInnerContent("                      value=\"#{myBean.value}\"");
        xhtmlCodeExample.appendInnerContent("                      required=\"true\">");
        xhtmlCodeExample.appendInnerContent("           </h:panelGroup>");
        xhtmlCodeExample.appendInnerContent("\n           <div class=\"col-md-2\">");
        xhtmlCodeExample.appendInnerContent("              <b:commandLink value=\"Submit\"");
        xhtmlCodeExample.appendInnerContent("                             styleClass=\"btn btn-success\">");
        xhtmlCodeExample.appendInnerContent("                 <f:ajax execute=\"rerenderArea\"");
        xhtmlCodeExample.appendInnerContent("                         render=\"rerenderArea\"/>");
        xhtmlCodeExample.appendInnerContent("              </b:commandLink>");
        xhtmlCodeExample.appendInnerContent("           </div>");
        xhtmlCodeExample.appendInnerContent("        </div>");
        xhtmlCodeExample.appendInnerContent("\n        <b:commandLink value=\"render (no resetValues)\"");
        xhtmlCodeExample.appendInnerContent("                       styleClass=\"btn btn-default\">");
        xhtmlCodeExample.appendInnerContent("           <f:ajax execute=\"@this\"");
        xhtmlCodeExample.appendInnerContent("                   render=\"rerenderArea\"/>");
        xhtmlCodeExample.appendInnerContent("        </b:commandLink>");
        xhtmlCodeExample.appendInnerContent("\n        <b:commandLink value=\"render (resetValues)\"");
        xhtmlCodeExample.appendInnerContent("                       styleClass=\"btn btn-default\">");
        xhtmlCodeExample.appendInnerContent("           <f:ajax execute=\"@this\"");
        xhtmlCodeExample.appendInnerContent("                   render=\"rerenderArea\"");
        xhtmlCodeExample.appendInnerContent("                   resetValues=\"true\"/>");
        xhtmlCodeExample.appendInnerContent("        </b:commandLink>");
        xhtmlCodeExample.appendInnerContent("\n        <h:commandLink value=\"render (reset values JSF2 default)\"");
        xhtmlCodeExample.appendInnerContent("                       styleClass=\"btn btn-default\">");
        xhtmlCodeExample.appendInnerContent("           <f:ajax execute=\"@this\"");
        xhtmlCodeExample.appendInnerContent("                   render=\"rerenderArea\"");
        xhtmlCodeExample.appendInnerContent("                   resetValues=\"true\"/>");
        xhtmlCodeExample.appendInnerContent("        </h:commandLink>");
        return xhtmlCodeExample;
    }

    private XhtmlCodeExample createXhtmlCodeExampleResetValues() {
        boolean useFontAwesome = this.getGlyphicon() != null && this.getGlyphicon().contains("fa");
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(useFontAwesome);
        xhtmlCodeExample.appendInnerContent("\n        <b:commandLink id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                       value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                       glyphicon=\"" + this.getGlyphicon() + "\"");
        xhtmlCodeExample.appendInnerContent("                       styleClass=\"" + this.getStyle() + "\"");
        xhtmlCodeExample.appendInnerContent("                       ajaxDisableLinkOnRequest=\"" + this.isAjaxDisableLinkOnRequest() + "\"");
        xhtmlCodeExample.appendInnerContent("                       ajaxShowWaitingDotsOnRequest=\"" + this.isAjaxShowWaitingDotsOnRequest() + "\"");
        xhtmlCodeExample.appendInnerContent("                       ajaxHideGlyphiconOnRequest=\"" + this.isAjaxHideGlyphiconOnRequest() + "\"");
        xhtmlCodeExample.appendInnerContent("                       ajaxDisableRenderRegionsOnRequest=\"" + this.isAjaxDisableRenderRegionsOnRequest() + "\"");
        if (!"Processing".equals(this.getAjaxProcessingText())) {
            xhtmlCodeExample.appendInnerContent("                       ajaxProcessingText=\"" + this.getAjaxProcessingText() + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.ajaxProcessingGlyphicon)) {
            xhtmlCodeExample.appendInnerContent("                       ajaxProcessingGlyphicon=\"" + this.ajaxProcessingGlyphicon + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                       action=\"#{myBean.increaseClick}\"");
        xhtmlCodeExample.appendInnerContent("                       rendered=\"" + this.isRendered() + "\">");
        if (this.commandLinkExampleType == CommandLinkExampleType.AJAX) {
            xhtmlCodeExample.appendInnerContent("            <f:ajax render=\"" + this.render + "\" />");
        }
        xhtmlCodeExample.appendInnerContent("        </b:commandLink>");
        xhtmlCodeExample.appendInnerContent("\n        <hr />");
        xhtmlCodeExample.appendInnerContent("\n        <h:panelGroup id=\"clicks\" layout=\"block\">");
        xhtmlCodeExample.appendInnerContent("            #{myBean.clicks} clicks");
        xhtmlCodeExample.appendInnerContent("        </h:panelGroup>");
        return xhtmlCodeExample;
    }

    public List<SelectItem> getGlyphicons() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem(null, "No glyphicon"));
        items.add(new SelectItem((Object)"glyphicon glyphicon-thumbs-up glyphicon-lg", "Bootstrap example"));
        items.add(new SelectItem((Object)"fa fa-language fa-lg", "Font-Awesome example"));
        return items;
    }

    public List<SelectItem> getStyles() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem(null, "default link"));
        items.add(new SelectItem((Object)"btn btn-primary", "Bootstrap button"));
        return items;
    }

    public List<SelectItem> getRenders() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)"clicks disabledOnRequest otherDisabledOnRequest", "some sections"));
        items.add(new SelectItem((Object)"@form", "@form"));
        items.add(new SelectItem((Object)"@this", "@this"));
        items.add(new SelectItem((Object)"@none", "@none"));
        return items;
    }

    public List<SelectItem> getCommandLinkExamples() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (CommandLinkExampleType type : CommandLinkExampleType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getGlyphicon() {
        return this.glyphicon;
    }

    public void setGlyphicon(String glyphicon) {
        this.glyphicon = glyphicon;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getClicks() {
        return this.clicks;
    }

    public boolean isAjaxDisableLinkOnRequest() {
        return this.ajaxDisableLinkOnRequest;
    }

    public void setAjaxDisableLinkOnRequest(boolean ajaxDisableLinkOnRequest) {
        this.ajaxDisableLinkOnRequest = ajaxDisableLinkOnRequest;
    }

    public boolean isAjaxShowWaitingDotsOnRequest() {
        return this.ajaxShowWaitingDotsOnRequest;
    }

    public void setAjaxShowWaitingDotsOnRequest(boolean ajaxShowWaitingDotsOnRequest) {
        this.ajaxShowWaitingDotsOnRequest = ajaxShowWaitingDotsOnRequest;
    }

    public String getAjaxProcessingText() {
        return this.ajaxProcessingText;
    }

    public void setAjaxProcessingText(String ajaxProcessingText) {
        this.ajaxProcessingText = ajaxProcessingText;
    }

    public boolean isAjaxHideGlyphiconOnRequest() {
        return this.ajaxHideGlyphiconOnRequest;
    }

    public void setAjaxHideGlyphiconOnRequest(boolean ajaxHideGlyphiconOnRequest) {
        this.ajaxHideGlyphiconOnRequest = ajaxHideGlyphiconOnRequest;
    }

    public boolean isAjaxDisableRenderRegionsOnRequest() {
        return this.ajaxDisableRenderRegionsOnRequest;
    }

    public void setAjaxDisableRenderRegionsOnRequest(boolean ajaxDisableRenderRegionsOnRequest) {
        this.ajaxDisableRenderRegionsOnRequest = ajaxDisableRenderRegionsOnRequest;
    }

    public String getRender() {
        return this.render;
    }

    public void setRender(String render) {
        this.render = render;
    }

    public CommandLinkExampleType getCommandLinkExampleType() {
        return this.commandLinkExampleType;
    }

    public void setCommandLinkExampleType(CommandLinkExampleType commandLinkExampleType) {
        this.commandLinkExampleType = commandLinkExampleType;
    }

    public String getAjaxProcessingGlyphicon() {
        return this.ajaxProcessingGlyphicon;
    }

    public void setAjaxProcessingGlyphicon(String ajaxProcessingGlyphicon) {
        this.ajaxProcessingGlyphicon = ajaxProcessingGlyphicon;
    }

    public String getResetValue() {
        return this.resetValue;
    }

    public void setResetValue(String resetValue) {
        this.resetValue = resetValue;
    }
}

