/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TempFileManager {
    public static final String TMPDIR_PROPERTY = "swarm.io.tmpdir";
    public static final TempFileManager INSTANCE = new TempFileManager();
    private Set<File> registered = Collections.newSetFromMap(new ConcurrentHashMap());
    private File tmpDir;

    private TempFileManager() {
        String tmpDir = System.getProperty(TMPDIR_PROPERTY);
        if (tmpDir != null) {
            this.tmpDir = new File(tmpDir);
            if (!Files.exists(this.tmpDir.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.tmpDir.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> INSTANCE.close()));
    }

    public File newTempDirectory(String base, String ext) throws IOException {
        File tmp = File.createTempFile(base, ext, this.tmpDir);
        tmp.delete();
        tmp.mkdirs();
        tmp.deleteOnExit();
        this.register(tmp);
        return tmp;
    }

    public File newTempFile(String base, String ext) throws IOException {
        File tmp = File.createTempFile(base, ext, this.tmpDir);
        tmp.delete();
        tmp.deleteOnExit();
        this.register(tmp);
        return tmp;
    }

    private void register(File file) {
        this.registered.add(file);
    }

    private void close() {
        for (File file : this.registered) {
            this.deleteRecursively(file);
        }
    }

    private void deleteRecursively(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }
}

