/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.table;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.CssCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.table.DemoPojo;
import de.larmic.butterfaces.component.showcase.table.FourthColumnWidthType;
import de.larmic.butterfaces.component.showcase.table.TableShowcase;
import de.larmic.butterfaces.component.showcase.table.ToolBarType;
import de.larmic.butterfaces.component.showcase.table.ToolbarFacetType;
import de.larmic.butterfaces.component.showcase.table.example.DemoPojoCodeExample;
import de.larmic.butterfaces.component.showcase.table.example.TableWebXmlExample;
import de.larmic.butterfaces.component.showcase.tree.SelectionAjaxType;
import de.larmic.butterfaces.event.TableSingleSelectionListener;
import de.larmic.butterfaces.model.table.DefaultTableModel;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.model.table.TableToolbarRefreshListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
@ViewScoped
public class TableShowcase
extends AbstractCodeShowcase
implements Serializable {
    private final List<DemoPojo> demoPojos = new ArrayList();
    private DemoPojo selectedValue = null;
    private String doSomethingWithRow = null;
    private SelectionAjaxType selectionAjaxType = SelectionAjaxType.AJAX;
    private FourthColumnWidthType fourthColumnWidthType = FourthColumnWidthType.NONE;
    private ToolBarType toolBarType = ToolBarType.SERVER_FILTER;
    private ToolbarFacetType toolbarFacetType = ToolbarFacetType.NONE;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private String refreshTooltip;
    private String columnOptionsTooltip;
    private boolean tableCondensed;
    private boolean tableBordered;
    private boolean tableStriped = true;
    private boolean showRefreshButton = true;
    private boolean showToggleColumnButton = true;
    private boolean showOrderColumnButton = true;
    private boolean ajaxDisableRenderRegionsOnRequest = true;
    private boolean useTableModel = true;
    private boolean useSelectionListener = true;
    private String filterValue;
    private String colWidthColumn1;
    private String colWidthColumn2;
    private String colWidthColumn3;
    private String colWidthColumn4;
    private int numberOfRefreshes;

    public TableShowcase() {
        this.tableModel.getTableRowSortingModel().sortColumn("filterTable", "column1", null, SortType.ASCENDING);
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        codeExamples.add((AbstractCodeExample)this.createXhtmlCodeExample());
        codeExamples.add((AbstractCodeExample)this.createMyBeanCodeExample());
        codeExamples.add((AbstractCodeExample)new DemoPojoCodeExample("table.demo"));
        codeExamples.add((AbstractCodeExample)new TableWebXmlExample());
        if (this.toolBarType == ToolBarType.TEXT) {
            CssCodeExample cssCodeExample = new CssCodeExample();
            cssCodeExample.addCss(".butter-table-toolbar-custom", new String[]{"margin-top: 10px;"});
            codeExamples.add((AbstractCodeExample)cssCodeExample);
        }
    }

    public List<DemoPojo> getStringRows() {
        if (this.demoPojos.isEmpty()) {
            for (int row = 0; row < 10; ++row) {
                int rowNumber = row + 1;
                this.demoPojos.add(new DemoPojo((long)rowNumber, String.format("r%sc1", rowNumber), String.format("r%sc2", rowNumber)));
            }
        }
        if (this.toolBarType == ToolBarType.SERVER_FILTER && StringUtils.isNotEmpty((CharSequence)this.filterValue)) {
            ArrayList<DemoPojo> filteredDemoPojos = new ArrayList<DemoPojo>();
            for (DemoPojo demoPojo : this.demoPojos) {
                if (!StringUtils.containsIgnoreCase((CharSequence)demoPojo.getA(), (CharSequence)this.filterValue) && !StringUtils.containsIgnoreCase((CharSequence)demoPojo.getB(), (CharSequence)this.filterValue)) continue;
                filteredDemoPojos.add(demoPojo);
            }
            return filteredDemoPojos;
        }
        if (this.shouldReverseRows()) {
            Collections.reverse(this.demoPojos);
        }
        return this.demoPojos;
    }

    private boolean shouldReverseRows() {
        if (!(this.tableModel.getTableRowSortingModel().getSortType(null, "column1") != SortType.ASCENDING && this.tableModel.getTableRowSortingModel().getSortType(null, "column3") != SortType.ASCENDING && this.tableModel.getTableRowSortingModel().getSortType(null, "column4") != SortType.ASCENDING || ((DemoPojo)this.demoPojos.get(0)).getA().equals("r1c1"))) {
            return true;
        }
        return (this.tableModel.getTableRowSortingModel().getSortType(null, "column1") == SortType.DESCENDING || this.tableModel.getTableRowSortingModel().getSortType(null, "column3") == SortType.DESCENDING || this.tableModel.getTableRowSortingModel().getSortType(null, "column4") == SortType.DESCENDING) && ((DemoPojo)this.demoPojos.get(0)).getA().equals("r1c1");
    }

    public TableSingleSelectionListener<DemoPojo> getTableSelectionListener() {
        if (this.useSelectionListener) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    private XhtmlCodeExample createXhtmlCodeExample() {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(true);
        if (this.showRefreshButton) {
            xhtmlCodeExample.appendInnerContent("        <h:panelGroup id=\"numberOfRefreshes\"");
            xhtmlCodeExample.appendInnerContent("                      layout=\"block\"");
            xhtmlCodeExample.appendInnerContent("                      styleClass=\"alert alert-success\">");
            xhtmlCodeExample.appendInnerContent("            Number of refresh clicks: #{myBean.numberOfRefreshes}");
            xhtmlCodeExample.appendInnerContent("        </h:panelGroup>\n");
        }
        xhtmlCodeExample.appendInnerContent("        <b:tableToolbar tableId=\"table\"");
        xhtmlCodeExample.appendInnerContent("                        ajaxDisableRenderRegionsOnRequest=\"" + this.ajaxDisableRenderRegionsOnRequest + "\"");
        if (this.showRefreshButton) {
            xhtmlCodeExample.appendInnerContent("                        refreshListener=\"#{myBean.toolbarRefreshListener}\"");
        }
        if (this.refreshTooltip != null) {
            xhtmlCodeExample.appendInnerContent("                        refreshTooltip=\"" + this.refreshTooltip + "\"");
        }
        if (this.columnOptionsTooltip != null) {
            xhtmlCodeExample.appendInnerContent("                        columnOptionsTooltip=\"" + this.columnOptionsTooltip + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                        rendered=\"" + this.isRendered() + "\">");
        if (this.showRefreshButton) {
            xhtmlCodeExample.appendInnerContent("            <!-- add refresh ajax event to enable refresh button -->");
            xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"refresh\" render=\"formId:numberOfRefreshes\" />");
        }
        if (this.showToggleColumnButton) {
            xhtmlCodeExample.appendInnerContent("            <!-- add toggle ajax event to enable toggle column buttons -->");
            xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"toggle\" />");
        }
        if (this.showOrderColumnButton) {
            xhtmlCodeExample.appendInnerContent("            <!-- add order ajax event to enable order column buttons -->");
            xhtmlCodeExample.appendInnerContent("            <f:ajax event=\"order\" />");
        }
        if (this.toolbarFacetType == ToolbarFacetType.LEFT_FACET) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"default-options-left\">");
            xhtmlCodeExample.appendInnerContent("                <a class=\"btn btn-default\">Left facet</a>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        } else if (this.toolbarFacetType == ToolbarFacetType.CENTER_FACET) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"default-options-center\">");
            xhtmlCodeExample.appendInnerContent("                <a class=\"btn btn-default\">Center facet</a>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        } else if (this.toolbarFacetType == ToolbarFacetType.RIGHT_FACET) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"default-options-right\">");
            xhtmlCodeExample.appendInnerContent("                <a class=\"btn btn-default\">Right facet</a>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        if (this.toolBarType == ToolBarType.TEXT) {
            xhtmlCodeExample.appendInnerContent("            Custom toolbar text...");
        } else if (this.toolBarType == ToolBarType.SERVER_FILTER) {
            xhtmlCodeExample.appendInnerContent("            <b:text value=\"#{myBean.filterValue}\"");
            xhtmlCodeExample.appendInnerContent("                    placeholder=\"Enter text...\"");
            xhtmlCodeExample.appendInnerContent("                    autoFocus=\"true\"");
            xhtmlCodeExample.appendInnerContent("                    hideLabel=\"true\">");
            xhtmlCodeExample.appendInnerContent("                <f:ajax event=\"keyup\" render=\"table\"/>");
            xhtmlCodeExample.appendInnerContent("            </b:text>");
        } else if (this.toolBarType == ToolBarType.CLIENT_FILTER) {
            xhtmlCodeExample.appendInnerContent("            <div class=\"form-inline pull-left\" role=\"form\">");
            xhtmlCodeExample.appendInnerContent("                <div class=\"form-group\">");
            xhtmlCodeExample.appendInnerContent("                    <input type=\"text\"");
            xhtmlCodeExample.appendInnerContent("                           class=\"form-control jQueryPluginSelector\"");
            xhtmlCodeExample.appendInnerContent("                           placeholder=\"Enter text...\"");
            xhtmlCodeExample.appendInnerContent("                           data-filterable-item-container=\".butter-table\"/>");
            xhtmlCodeExample.appendInnerContent("                </div>");
            xhtmlCodeExample.appendInnerContent("            </div>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:tableToolbar>\n");
        xhtmlCodeExample.appendInnerContent("        <b:table id=\"table\"");
        xhtmlCodeExample.appendInnerContent("                 var=\"rowItem\"");
        xhtmlCodeExample.appendInnerContent("                 value=\"#{myBean.value}\"");
        if (this.useTableModel) {
            xhtmlCodeExample.appendInnerContent("                 model=\"#{myBean.tableModel}\"");
        }
        if (this.selectionAjaxType == SelectionAjaxType.AJAX && this.useSelectionListener) {
            xhtmlCodeExample.appendInnerContent("                 singleSelectionListener=\"#{myBean}\"");
        }
        if (this.toolBarType == ToolBarType.CLIENT_FILTER) {
            xhtmlCodeExample.appendInnerContent("                 rowClass=\"filterable-item\"");
        }
        xhtmlCodeExample.appendInnerContent("                 tableBordered=\"" + this.tableBordered + "\"");
        xhtmlCodeExample.appendInnerContent("                 tableCondensed=\"" + this.tableCondensed + "\"");
        xhtmlCodeExample.appendInnerContent("                 tableStriped=\"" + this.tableStriped + "\"");
        xhtmlCodeExample.appendInnerContent("                 ajaxDisableRenderRegionsOnRequest=\"" + this.ajaxDisableRenderRegionsOnRequest + "\"");
        xhtmlCodeExample.appendInnerContent("                 rendered=\"" + this.isRendered() + "\">");
        xhtmlCodeExample.appendInnerContent("            <!-- at this time you have to put an ajax tag to activate some features-->");
        if (this.selectionAjaxType == SelectionAjaxType.AJAX) {
            xhtmlCodeExample.appendInnerContent("            <f:ajax render=\"formId:selectedRow\"/>");
        } else if (this.selectionAjaxType == SelectionAjaxType.AJAX_DISABLED) {
            xhtmlCodeExample.appendInnerContent("            <f:ajax render=\"formId:selectedRow\" disabled=\"true\"/>");
        }
        xhtmlCodeExample.appendInnerContent("            <b:column id=\"column1\"");
        if (this.fourthColumnWidthType == FourthColumnWidthType.PERCENT) {
            xhtmlCodeExample.appendInnerContent("                    colWidth=\"10%\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.PX) {
            xhtmlCodeExample.appendInnerContent("                    colWidth=\"50px\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.RELATIVE) {
            xhtmlCodeExample.appendInnerContent("                    colWidth=\"5*\"");
        }
        xhtmlCodeExample.appendInnerContent("                      label=\"Readonly text\">");
        xhtmlCodeExample.appendInnerContent("                /* text */");
        xhtmlCodeExample.appendInnerContent("                <b:tooltip placement=\"top\">");
        xhtmlCodeExample.appendInnerContent("                   /* tooltip text */");
        xhtmlCodeExample.appendInnerContent("                </b:tooltip>");
        xhtmlCodeExample.appendInnerContent("            </b:column>");
        xhtmlCodeExample.appendInnerContent("            <b:column id=\"column2\"");
        if (this.fourthColumnWidthType == FourthColumnWidthType.PERCENT) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"65%\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.PX) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"30px\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.RELATIVE) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"1*\"");
        }
        xhtmlCodeExample.appendInnerContent("                      sortColumnEnabled=\"false\"");
        xhtmlCodeExample.appendInnerContent("                      label=\"Action\">");
        xhtmlCodeExample.appendInnerContent("                /* action */");
        xhtmlCodeExample.appendInnerContent("            </b:column>");
        xhtmlCodeExample.appendInnerContent("            <b:column id=\"column3\"");
        if (this.fourthColumnWidthType == FourthColumnWidthType.PERCENT) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"15%\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.PX) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"10px\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.RELATIVE) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"1*\"");
        }
        xhtmlCodeExample.appendInnerContent("                      label=\"Creation date\">");
        xhtmlCodeExample.appendInnerContent("                /* date */");
        xhtmlCodeExample.appendInnerContent("            </b:column>");
        xhtmlCodeExample.appendInnerContent("            <b:column id=\"column4\"");
        if (this.fourthColumnWidthType == FourthColumnWidthType.PERCENT) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"10%\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.PX) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"10px\"");
        } else if (this.fourthColumnWidthType == FourthColumnWidthType.RELATIVE) {
            xhtmlCodeExample.appendInnerContent("                      colWidth=\"1*\"");
        }
        xhtmlCodeExample.appendInnerContent("                      sortColumnEnabled=\"false\"");
        xhtmlCodeExample.appendInnerContent("                      hideColumn=\"true\"");
        xhtmlCodeExample.appendInnerContent("                      label=\"Readonly text (default hide)\">");
        xhtmlCodeExample.appendInnerContent("                /* disabled input with text */");
        xhtmlCodeExample.appendInnerContent("            </b:column>");
        xhtmlCodeExample.appendInnerContent("        </b:table>");
        if (this.selectionAjaxType != SelectionAjaxType.NONE) {
            xhtmlCodeExample.appendInnerContent("\n        <h:panelGroup id=\"selectedRow\">");
            xhtmlCodeExample.appendInnerContent("            <h:output value=\"#{myBean.selectedRow.a}\"");
            xhtmlCodeExample.appendInnerContent("                      rendered=\"#{not empty myBean.selectedRow}\"/>");
            xhtmlCodeExample.appendInnerContent("        <h:panelGroup/>");
        }
        if (this.toolBarType == ToolBarType.CLIENT_FILTER) {
            xhtmlCodeExample.appendInnerContent("\n        /* activate client side filter jquery plugin */");
            xhtmlCodeExample.appendInnerContent("        <b:activateLibraries>");
            xhtmlCodeExample.appendInnerContent("        <script type=\"text/javascript\">");
            xhtmlCodeExample.appendInnerContent("            jQuery('.jQueryPluginSelector').butterItemFilterField();");
            xhtmlCodeExample.appendInnerContent("        </script>");
        }
        return xhtmlCodeExample;
    }

    private JavaCodeExample createMyBeanCodeExample() {
        JavaCodeExample myBean = new JavaCodeExample("MyBean.java", "mybean", "table.demo", "MyBean", true);
        if (this.selectionAjaxType == SelectionAjaxType.AJAX) {
            myBean.addImport("de.larmic.butterfaces.event.TableSingleSelectionListener");
        }
        if (this.useTableModel) {
            myBean.addImport("de.larmic.butterfaces.model.table.TableModel");
            myBean.addImport("de.larmic.butterfaces.model.table.DefaultTableModel");
        }
        if (this.showRefreshButton) {
            myBean.addImport("de.larmic.butterfaces.model.table.TableToolbarRefreshListener");
        }
        myBean.addImport("javax.faces.view.ViewScoped");
        myBean.addImport("javax.inject.Named");
        if (this.selectionAjaxType == SelectionAjaxType.AJAX) {
            myBean.addInterfaces("TableSingleSelectionListener");
        }
        if (this.showRefreshButton) {
            myBean.addInterfaces("TableToolbarRefreshListener");
        }
        if (this.useTableModel) {
            myBean.appendInnerContent("    private TableModel tableModel = new DefaultTableModel();\n");
        }
        if (this.toolBarType == ToolBarType.SERVER_FILTER) {
            myBean.appendInnerContent("    private String filterValue;\n");
        }
        if (this.showRefreshButton) {
            myBean.appendInnerContent("    private int numberOfRefreshes;\n");
        }
        if (this.useTableModel) {
            myBean.appendInnerContent("    @PostConstruct");
            myBean.appendInnerContent("    public init() {");
            myBean.appendInnerContent("       // initial table ordering by first column");
            myBean.appendInnerContent("       tableModel.getTableRowSortingModel()");
            myBean.appendInnerContent("              .sortColumn(\"table\", \"column1\", null, SortType.ASCENDING);");
            myBean.appendInnerContent("    }");
        }
        myBean.appendInnerContent("    public List<DemoPojo> getValue() {");
        myBean.appendInnerContent("        final List<DemoPojo> pairs = new ArrayList<>();");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(1L, \"r1c1\", \"r1c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(2L, \"r2c1\", \"r2c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(3L, \"r3c1\", \"r3c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(4L, \"r4c1\", \"r4c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(5L, \"r5c1\", \"r5c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(6L, \"r6c1\", \"r6c2\"));");
        myBean.appendInnerContent("        pairs.add(new DemoPojo(7L, \"r7c1\", \"r7c2\"));");
        if (this.selectionAjaxType == SelectionAjaxType.AJAX && this.useTableModel) {
            myBean.appendInnerContent("        // TODO sort by table model");
        }
        if (this.toolBarType == ToolBarType.SERVER_FILTER) {
            myBean.appendInnerContent("        return this.filterByValue(pairs, this.filterValue);");
        } else {
            myBean.appendInnerContent("        return pairs;");
        }
        myBean.appendInnerContent("    }\n");
        if (this.selectionAjaxType == SelectionAjaxType.AJAX) {
            myBean.appendInnerContent("    private DemoPojo selectedRow;\n");
            myBean.appendInnerContent("    @Override");
            myBean.appendInnerContent("    public void processTableSelection(final DemoPojo data) {");
            myBean.appendInnerContent("        this.selectedRow = data;");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    @Override");
            myBean.appendInnerContent("    public boolean isValueSelected(DemoPojo data) {");
            myBean.appendInnerContent("        return selectedRow != null ? data.getId() == selectedRow.getId() : false;");
            myBean.appendInnerContent("    }\n");
        }
        if (this.showRefreshButton) {
            myBean.appendInnerContent("    @Override");
            myBean.appendInnerContent("    public void onPreRefresh() {");
            myBean.appendInnerContent("        numberOfRefreshes++;");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    public int getNumberOfRefreshes() {");
            myBean.appendInnerContent("        return numberOfRefreshes;");
            myBean.appendInnerContent("    }\n");
        }
        if (this.toolBarType == ToolBarType.SERVER_FILTER) {
            myBean.appendInnerContent("    public List<DemoPojo> filterByValue(final List<DemoPojo> pairs,");
            myBean.appendInnerContent("                                          final String filterValue) {");
            myBean.appendInnerContent("        // TODO implement me");
            myBean.appendInnerContent("        return pairs;");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    public String getFilterValue() {");
            myBean.appendInnerContent("        return this.filterValue;");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    public void setFilterValue(final String filterValue) {");
            myBean.appendInnerContent("        this.filterValue = filterValue;");
            myBean.appendInnerContent("    }\n");
        }
        if (this.selectionAjaxType == SelectionAjaxType.AJAX) {
            myBean.appendInnerContent("    public DemoPojo getSelectedRow() {");
            myBean.appendInnerContent("        return selectedRow;");
            myBean.appendInnerContent("    }\n");
        }
        if (this.useTableModel) {
            myBean.appendInnerContent("    public TableModel getTableModel() {");
            myBean.appendInnerContent("        return this.tableModel;");
            myBean.appendInnerContent("    }");
        }
        return myBean;
    }

    public List<SelectItem> getAjaxSelectionTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (SelectionAjaxType type : SelectionAjaxType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getToolBarFacetTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ToolbarFacetType type : ToolbarFacetType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getToolBarTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ToolBarType type : ToolBarType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getTwoColumnWidthTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (FourthColumnWidthType type : FourthColumnWidthType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public void doSomethingWith(DemoPojo selectedValue) {
        this.doSomethingWithRow = "I have done something with " + (selectedValue == null ? "null" : selectedValue.getA());
    }

    public SelectionAjaxType getSelectionAjaxType() {
        return this.selectionAjaxType;
    }

    public void setSelectionAjaxType(SelectionAjaxType selectionAjaxType) {
        this.selectionAjaxType = selectionAjaxType;
    }

    public DemoPojo getSelectedValue() {
        return this.selectedValue;
    }

    public String getDoSomethingWithRow() {
        return this.doSomethingWithRow;
    }

    public boolean isTableCondensed() {
        return this.tableCondensed;
    }

    public void setTableCondensed(boolean tableCondensed) {
        this.tableCondensed = tableCondensed;
    }

    public boolean isTableBordered() {
        return this.tableBordered;
    }

    public void setTableBordered(boolean tableBordered) {
        this.tableBordered = tableBordered;
    }

    public boolean isTableStriped() {
        return this.tableStriped;
    }

    public void setTableStriped(boolean tableStriped) {
        this.tableStriped = tableStriped;
    }

    public boolean isShowRefreshButton() {
        return this.showRefreshButton;
    }

    public void setShowRefreshButton(boolean showRefreshButton) {
        this.showRefreshButton = showRefreshButton;
    }

    public boolean isShowToggleColumnButton() {
        return this.showToggleColumnButton;
    }

    public boolean isShowOrderColumnButton() {
        return this.showOrderColumnButton;
    }

    public void setShowOrderColumnButton(boolean showOrderColumnButton) {
        this.showOrderColumnButton = showOrderColumnButton;
    }

    public TableToolbarRefreshListener getToolbarRefreshListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setShowToggleColumnButton(boolean showToggleColumnButton) {
        this.showToggleColumnButton = showToggleColumnButton;
    }

    public FourthColumnWidthType getFourthColumnWidthType() {
        return this.fourthColumnWidthType;
    }

    public void setFourthColumnWidthType(FourthColumnWidthType fourthColumnWidthType) {
        this.fourthColumnWidthType = fourthColumnWidthType;
        switch (3.$SwitchMap$de$larmic$butterfaces$component$showcase$table$FourthColumnWidthType[this.fourthColumnWidthType.ordinal()]) {
            case 1: {
                this.colWidthColumn1 = null;
                this.colWidthColumn2 = null;
                this.colWidthColumn3 = null;
                this.colWidthColumn4 = null;
                break;
            }
            case 2: {
                this.colWidthColumn1 = "10%";
                this.colWidthColumn2 = "65%";
                this.colWidthColumn3 = "15%";
                this.colWidthColumn4 = "10%";
                break;
            }
            case 3: {
                this.colWidthColumn1 = "50px";
                this.colWidthColumn2 = "30px";
                this.colWidthColumn3 = "10px";
                this.colWidthColumn4 = "10px";
                break;
            }
            case 4: {
                this.colWidthColumn1 = "5*";
                this.colWidthColumn2 = "1*";
                this.colWidthColumn3 = "7*";
                this.colWidthColumn4 = "1*";
            }
        }
    }

    public String getColWidthColumn1() {
        return this.colWidthColumn1;
    }

    public String getColWidthColumn2() {
        return this.colWidthColumn2;
    }

    public String getColWidthColumn3() {
        return this.colWidthColumn3;
    }

    public String getColWidthColumn4() {
        return this.colWidthColumn4;
    }

    public DefaultTableModel getTableModel() {
        if (this.useTableModel) {
            return this.tableModel;
        }
        return null;
    }

    public ToolBarType getToolBarType() {
        return this.toolBarType;
    }

    public void setToolBarType(ToolBarType toolBarType) {
        this.toolBarType = toolBarType;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public String getRowClass() {
        return this.toolBarType == ToolBarType.CLIENT_FILTER ? "filterable-item" : null;
    }

    public boolean isAjaxDisableRenderRegionsOnRequest() {
        return this.ajaxDisableRenderRegionsOnRequest;
    }

    public void setAjaxDisableRenderRegionsOnRequest(boolean ajaxDisableRenderRegionsOnRequest) {
        this.ajaxDisableRenderRegionsOnRequest = ajaxDisableRenderRegionsOnRequest;
    }

    public String getRefreshTooltip() {
        return this.refreshTooltip;
    }

    public void setRefreshTooltip(String refreshTooltip) {
        this.refreshTooltip = refreshTooltip;
    }

    public String getColumnOptionsTooltip() {
        return this.columnOptionsTooltip;
    }

    public void setColumnOptionsTooltip(String columnOptionsTooltip) {
        this.columnOptionsTooltip = columnOptionsTooltip;
    }

    public ToolbarFacetType getToolbarFacetType() {
        return this.toolbarFacetType;
    }

    public void setToolbarFacetType(ToolbarFacetType toolbarFacetType) {
        this.toolbarFacetType = toolbarFacetType;
    }

    public int getNumberOfRefreshes() {
        return this.numberOfRefreshes;
    }

    public boolean isUseTableModel() {
        return this.useTableModel;
    }

    public void setUseTableModel(boolean useTableModel) {
        this.useTableModel = useTableModel;
    }

    public boolean isUseSelectionListener() {
        return this.useSelectionListener;
    }

    public void setUseSelectionListener(boolean useSelectionListener) {
        this.useSelectionListener = useSelectionListener;
    }

    static /* synthetic */ DemoPojo access$002(TableShowcase x0, DemoPojo x1) {
        x0.selectedValue = x1;
        return x0.selectedValue;
    }

    static /* synthetic */ DemoPojo access$000(TableShowcase x0) {
        return x0.selectedValue;
    }

    static /* synthetic */ int access$108(TableShowcase x0) {
        return x0.numberOfRefreshes++;
    }
}

