/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;

public class WildFlySwarmDependenciesConf {
    public static final String CLASSPATH_LOCATION = "META-INF/wildfly-swarm-dependencies.conf";
    private List<MavenArtifactDescriptor> primaryDependencies = new ArrayList<MavenArtifactDescriptor>();
    private List<MavenArtifactDescriptor> extraDependencies = new ArrayList<MavenArtifactDescriptor>();

    public WildFlySwarmDependenciesConf() {
    }

    public WildFlySwarmDependenciesConf(InputStream in) throws IOException {
        this.read(in);
    }

    public void read(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                if (line.startsWith("primary:")) {
                    this.primaryDependencies.add(MavenArtifactDescriptor.fromMscGav(line.substring(8)));
                    continue;
                }
                if (!line.startsWith("extra:")) continue;
                this.extraDependencies.add(MavenArtifactDescriptor.fromMavenGav(line.substring(6)));
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        for (MavenArtifactDescriptor dependency : this.primaryDependencies) {
            writer.println("primary:" + dependency.mscGav());
        }
        for (MavenArtifactDescriptor dependency : this.extraDependencies) {
            writer.println("extra:" + dependency.mavenGav());
        }
        writer.flush();
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out);
            out.close();
            return new String(out.toByteArray());
        }
        catch (IOException e) {
            return "";
        }
    }

    public void addPrimaryDependency(MavenArtifactDescriptor dep) {
        this.primaryDependencies.add(dep);
    }

    public List<MavenArtifactDescriptor> getPrimaryDependencies() {
        return Collections.unmodifiableList(this.primaryDependencies);
    }

    public void addExtraDependency(MavenArtifactDescriptor dep) {
        this.extraDependencies.add(dep);
    }

    public List<MavenArtifactDescriptor> getExtraDependencies() {
        return Collections.unmodifiableList(this.extraDependencies);
    }

    public MavenArtifactDescriptor find(String groupId, String artifactId, String packaging, String classifier) {
        if (classifier != null && classifier.trim().isEmpty()) {
            classifier = null;
        }
        for (MavenArtifactDescriptor each : this.primaryDependencies) {
            if (!each.groupId().equals(groupId) || !each.artifactId().equals(artifactId) || !each.type().equals(packaging)) continue;
            if (classifier == null && each.classifier() == null) {
                return each;
            }
            if (classifier == null || each.classifier() == null || !each.classifier().equals(classifier)) continue;
            return each;
        }
        for (MavenArtifactDescriptor each : this.extraDependencies) {
            if (!each.groupId().equals(groupId) || !each.artifactId().equals(artifactId) || !each.type().equals(packaging)) continue;
            if (classifier == null && each.classifier() == null) {
                return each;
            }
            if (classifier == null || each.classifier() == null || !each.classifier().equals(classifier)) continue;
            return each;
        }
        return null;
    }
}

