/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import com.sun.org.apache.bcel.internal.util.ClassLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.ApplicationModuleFinder;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmClasspathConf;

public class FlattishApplicationModuleFinder
extends ApplicationModuleFinder {
    public static final String MODULE_NAME = "swarm.application";
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.application.spring");

    public FlattishApplicationModuleFinder() {
        super("flattish");
    }

    @Override
    public void buildModule(ModuleSpec.Builder builder, ModuleLoader delegateLoader) throws ModuleLoadException {
        super.buildModule(builder, delegateLoader);
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.vfs")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.shrinkwrap")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.wildfly.swarm.container")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.wildfly.swarm.container", "runtime")));
        String classPath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        try {
            WildFlySwarmClasspathConf classpathConf = new WildFlySwarmClasspathConf(ClassLoader.getSystemClassLoader());
            while (tokenizer.hasMoreTokens()) {
                String each = tokenizer.nextToken();
                Path path = Paths.get(each, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createFileResourceLoader(path.getFileName().toString(), path.toFile())));
                    continue;
                }
                try {
                    JarFile jar = new JarFile(path.toFile());
                    Set<WildFlySwarmClasspathConf.Action> actions = classpathConf.getActions(jar);
                    if (actions.isEmpty()) {
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(path.getFileName().toString(), new JarFile(path.toFile()))));
                        continue;
                    }
                    for (WildFlySwarmClasspathConf.Action action : actions) {
                        if (!(action instanceof WildFlySwarmClasspathConf.ReplaceAction)) continue;
                        WildFlySwarmClasspathConf.ReplaceAction replace = (WildFlySwarmClasspathConf.ReplaceAction)action;
                        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create(replace.moduleName, replace.moduleSlot)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

