/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.tree;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.text.FacetType;
import de.larmic.butterfaces.component.showcase.tree.Episodes;
import de.larmic.butterfaces.component.showcase.tree.ShowcaseTreeNode;
import de.larmic.butterfaces.component.showcase.tree.TreeBoxExampleType;
import de.larmic.butterfaces.component.showcase.tree.TreeBoxShowcase;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxExampleEnum;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxExampleEnumJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxListOfEnumsJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxListOfNodesJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxListOfStringsJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxRootNodeJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.TreeBoxWebXmlExample;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxEpisodesCssExample;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxEpisodesJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxImageJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxListOfEpisodesJavaExample;
import de.larmic.butterfaces.model.tree.EnumTreeBoxWrapper;
import de.larmic.butterfaces.model.tree.Node;
import de.larmic.butterfaces.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class TreeBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private final ShowcaseTreeNode showcaseTreeNode = new ShowcaseTreeNode();
    private FacetType selectedFacetType = FacetType.NONE;
    private TreeBoxExampleType selectedTreeBoxExampleType = TreeBoxExampleType.ROOT_NODE;
    private String placeholder = "Enter text...";
    private String inputTextProperty;
    private boolean autoFocus;
    private String noEntriesText;
    private String spinnerText;

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        if (this.getValue() instanceof TreeBoxExampleEnum) {
            return this.getEnumTranslation((TreeBoxExampleEnum)this.getValue());
        }
        if (this.getValue() instanceof Node) {
            return ((Node)this.getValue()).getTitle();
        }
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        return null;
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        codeExamples.add((AbstractCodeExample)this.buildXhtmlCodeExample());
        if (this.selectedTreeBoxExampleType == TreeBoxExampleType.NODES) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfNodesJavaExample(this.showcaseTreeNode));
        } else if (this.selectedTreeBoxExampleType == TreeBoxExampleType.ROOT_NODE) {
            codeExamples.add((AbstractCodeExample)new TreeBoxRootNodeJavaExample(this.selectedTreeBoxExampleType, this.showcaseTreeNode));
        } else if (this.selectedTreeBoxExampleType == TreeBoxExampleType.TEMPLATE) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfEpisodesJavaExample("treeBox.demo"));
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesJavaExample("treeBox.demo", true));
            codeExamples.add((AbstractCodeExample)new TreeBoxImageJavaExample("treeBox.demo"));
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesCssExample());
        } else if (this.selectedTreeBoxExampleType == TreeBoxExampleType.STRINGS) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfStringsJavaExample());
        } else if (this.selectedTreeBoxExampleType == TreeBoxExampleType.OBJECTS) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfEpisodesJavaExample("treeBox.demo"));
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesJavaExample("treeBox.demo", true));
            codeExamples.add((AbstractCodeExample)new TreeBoxImageJavaExample("treeBox.demo"));
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesCssExample());
        } else if (this.selectedTreeBoxExampleType == TreeBoxExampleType.ENUMS) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfEnumsJavaExample());
            codeExamples.add((AbstractCodeExample)new TreeBoxExampleEnumJavaExample());
        }
        if (this.isValidation()) {
            codeExamples.add(this.buildValidatorCodeExample());
        }
        this.generateDemoCSS(codeExamples);
        codeExamples.add((AbstractCodeExample)new TreeBoxWebXmlExample());
    }

    private XhtmlCodeExample buildXhtmlCodeExample() {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:treeBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                   label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                   hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                   value=\"#{myBean.selectedValue}\"");
        xhtmlCodeExample.appendInnerContent("                   values=\"#{myBean.values}\"");
        xhtmlCodeExample.appendInnerContent("                   placeholder=\"" + this.getPlaceholder() + "\"");
        xhtmlCodeExample.appendInnerContent("                   styleClass=\"" + StringUtils.getNotNullValue((String)this.getStyleClass(), (String)"") + "\"");
        xhtmlCodeExample.appendInnerContent("                   readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                   disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                   inputTextProperty=\"" + this.getInputTextProperty() + "\"");
        xhtmlCodeExample.appendInnerContent("                   required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                   autoFocus=\"" + this.isAutoFocus() + "\"");
        if (StringUtils.isNotEmpty((String)this.spinnerText)) {
            xhtmlCodeExample.appendInnerContent("                   spinnerText=\"" + this.spinnerText + "\"");
        }
        if (StringUtils.isNotEmpty((String)this.noEntriesText)) {
            xhtmlCodeExample.appendInnerContent("                   noEntriesText=\"" + this.noEntriesText + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                   rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (this.selectedTreeBoxExampleType == TreeBoxExampleType.TEMPLATE) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"selectedEntryTemplate\">");
            xhtmlCodeExample.appendInnerContent("                 <div class=\"stargateEpisodeItem\">");
            xhtmlCodeExample.appendInnerContent("                      <img class=\"stargateEpisodeImg small\"");
            xhtmlCodeExample.appendInnerContent("                           src=\"{{image.url}}\" alt=\"{{title}}\"/>");
            xhtmlCodeExample.appendInnerContent("                      <div class=\"stargateEpisodeDetails\">");
            xhtmlCodeExample.appendInnerContent("                           <h4>{{title}} <small>({{originalAirDate}})</small></h4>");
            xhtmlCodeExample.appendInnerContent("                      </div>");
            xhtmlCodeExample.appendInnerContent("                 </div>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"template\">");
            xhtmlCodeExample.appendInnerContent("                 <div class=\"stargateEpisodeItem\">");
            xhtmlCodeExample.appendInnerContent("                      <img class=\"stargateEpisodeImg\"");
            xhtmlCodeExample.appendInnerContent("                           src=\"{{image.url}}\" alt=\"{{title}}\"/>");
            xhtmlCodeExample.appendInnerContent("                      <div class=\"stargateEpisodeDetails\">");
            xhtmlCodeExample.appendInnerContent("                           <h4>{{title}} <small>({{originalAirDate}})</small></h4>");
            xhtmlCodeExample.appendInnerContent("                           <div>");
            xhtmlCodeExample.appendInnerContent("                                <label>Episode:</label>");
            xhtmlCodeExample.appendInnerContent("                                <span>");
            xhtmlCodeExample.appendInnerContent("                                     No. {{numberInSeries}} of Stargate - Kommando SG-1, ");
            xhtmlCodeExample.appendInnerContent("                                     Season 1</span>");
            xhtmlCodeExample.appendInnerContent("                                </span>");
            xhtmlCodeExample.appendInnerContent("                           </div>");
            xhtmlCodeExample.appendInnerContent("                           <div>");
            xhtmlCodeExample.appendInnerContent("                                <label>written by:</label>");
            xhtmlCodeExample.appendInnerContent("                                <span>{{writtenBy}}</span>");
            xhtmlCodeExample.appendInnerContent("                           </div>");
            xhtmlCodeExample.appendInnerContent("                      </div>");
            xhtmlCodeExample.appendInnerContent("                 </div>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validator validatorId=\"treeBoxValidator\" />");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:treeBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        return xhtmlCodeExample;
    }

    private AbstractCodeExample buildValidatorCodeExample() {
        JavaCodeExample codeExample = new JavaCodeExample("TreeBoxValidator.java", "validator", "treeBox", "TreeBoxValidator", false, "@FacesValidator");
        codeExample.addInterfaces("Validator");
        codeExample.addImport("de.larmic.butterfaces.model.tree.Node");
        codeExample.addImport("javax.faces.application.FacesMessage");
        codeExample.addImport("javax.faces.component.UIComponent");
        codeExample.addImport("javax.faces.context.FacesContext");
        codeExample.addImport("javax.faces.validator.FacesValidator");
        codeExample.addImport("javax.faces.validator.Validator");
        codeExample.addImport("javax.faces.validator.ValidatorException");
        codeExample.appendInnerContent("   private static final String ERROR_MESSAGE = \"Selecting root node is not allowed\";\n");
        codeExample.appendInnerContent("   @Override");
        codeExample.appendInnerContent("   public void validate(FacesContext context,");
        codeExample.appendInnerContent("                        UIComponent component,");
        codeExample.appendInnerContent("                        Object value) throws ValidatorException {");
        codeExample.appendInnerContent("      if (value instanceof Node");
        codeExample.appendInnerContent("            && \"rootNode\".equals(((Node) value).getTitle())) {");
        codeExample.appendInnerContent("         final FacesMessage message = new FacesMessage(ERROR_MESSAGE);");
        codeExample.appendInnerContent("         throw new ValidatorException(message);");
        codeExample.appendInnerContent("      }");
        codeExample.appendInnerContent("   }");
        return codeExample;
    }

    public List<SelectItem> getAvailableFacetTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (FacetType type : FacetType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getTreeBoxExampleTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (TreeBoxExampleType type : TreeBoxExampleType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public Object getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$tree$TreeBoxExampleType[this.selectedTreeBoxExampleType.ordinal()]) {
            case 1: {
                return this.showcaseTreeNode.getTree().getSubNodes();
            }
            case 2: {
                return this.showcaseTreeNode.getTree();
            }
            case 3: {
                return this.getEnumValues();
            }
            case 4: 
            case 5: {
                return Episodes.EPISODES;
            }
        }
        return Arrays.asList("Inbox", "Drafts", "Sent", "Tagged", "Folders", "Trash");
    }

    private String getEnumTranslation(TreeBoxExampleEnum treeBoxExampleEnum) {
        for (EnumTreeBoxWrapper enumTreeBoxWrapper : this.getEnumValues()) {
            if (!enumTreeBoxWrapper.getEnumValue().equals(treeBoxExampleEnum)) continue;
            return enumTreeBoxWrapper.getTranslation();
        }
        return null;
    }

    private List<EnumTreeBoxWrapper> getEnumValues() {
        ArrayList<EnumTreeBoxWrapper> wrappedEnums = new ArrayList<EnumTreeBoxWrapper>();
        wrappedEnums.add(new EnumTreeBoxWrapper((Enum)TreeBoxExampleEnum.MAIL, "E-Mail"));
        wrappedEnums.add(new EnumTreeBoxWrapper((Enum)TreeBoxExampleEnum.PDF, "PDF"));
        wrappedEnums.add(new EnumTreeBoxWrapper((Enum)TreeBoxExampleEnum.TXT, "plain text"));
        return wrappedEnums;
    }

    public FacetType getSelectedFacetType() {
        return this.selectedFacetType;
    }

    public void setSelectedFacetType(FacetType selectedFacetType) {
        this.selectedFacetType = selectedFacetType;
    }

    public String getNoEntriesText() {
        return this.noEntriesText;
    }

    public void setNoEntriesText(String noEntriesText) {
        this.noEntriesText = noEntriesText;
    }

    public String getSpinnerText() {
        return this.spinnerText;
    }

    public void setSpinnerText(String spinnerText) {
        this.spinnerText = spinnerText;
    }

    public TreeBoxExampleType getSelectedTreeBoxExampleType() {
        return this.selectedTreeBoxExampleType;
    }

    public void setSelectedTreeBoxExampleType(TreeBoxExampleType selectedTreeBoxExampleType) {
        this.selectedTreeBoxExampleType = selectedTreeBoxExampleType;
    }

    public String getInputTextProperty() {
        return this.inputTextProperty;
    }

    public void setInputTextProperty(String inputTextProperty) {
        this.inputTextProperty = inputTextProperty;
    }
}

