/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.radioBox;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.radioBox.Foo;
import de.larmic.butterfaces.component.showcase.radioBox.FooType;
import de.larmic.butterfaces.component.showcase.radioBox.RadioBoxShowcase;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxFooExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxFooTypeExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfEnumsMyBeanExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfObjectsMyBeanExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfStringsMyBeanExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfTemplatesCssExample;
import de.larmic.butterfaces.component.showcase.tree.Episode;
import de.larmic.butterfaces.component.showcase.tree.Episodes;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxEpisodesJavaExample;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxListOfEpisodesJavaExample;
import de.larmic.butterfaces.component.showcase.type.RadioBoxExampleType;
import de.larmic.butterfaces.component.showcase.type.RadioBoxLayoutType;
import de.larmic.butterfaces.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class RadioBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private RadioBoxExampleType exampleType = RadioBoxExampleType.STRING;
    private RadioBoxLayoutType radioBoxLayoutType = RadioBoxLayoutType.LINE_DIRECTION;
    private final List<Foo> foos = new ArrayList();
    private final List<String> strings = new ArrayList();

    public RadioBoxShowcase() {
        this.initFoos();
        this.initStrings();
    }

    protected Object initValue() {
        return null;
    }

    public Object getValue() {
        if (super.getValue() != null) {
            return super.getValue();
        }
        return "(item is null)";
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:radioBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"#{myBean.selectedValue}\"");
        xhtmlCodeExample.appendInnerContent("                    values=\"#{myBean.values}\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (RadioBoxExampleType.TEMPLATE.equals((Object)this.exampleType)) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"template\">");
            xhtmlCodeExample.appendInnerContent("               <div class=\"radio-box-stargate-template\">");
            xhtmlCodeExample.appendInnerContent("                  <h4>{{title}}");
            xhtmlCodeExample.appendInnerContent("                     <small>({{originalAirDate}})</small>");
            xhtmlCodeExample.appendInnerContent("                  </h4>");
            xhtmlCodeExample.appendInnerContent("                  <div>");
            xhtmlCodeExample.appendInnerContent("                     <label>Episode:</label>");
            xhtmlCodeExample.appendInnerContent("                     <span>No. {{numberInSeries}} of Stargate - Kommando SG-1, Season 1</span>");
            xhtmlCodeExample.appendInnerContent("                  </div>");
            xhtmlCodeExample.appendInnerContent("                  <div>");
            xhtmlCodeExample.appendInnerContent("                     <label>written by:</label>");
            xhtmlCodeExample.appendInnerContent("                     <span>{{writtenBy}}</span>");
            xhtmlCodeExample.appendInnerContent("                  </div>");
            xhtmlCodeExample.appendInnerContent("               </div>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:radioBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        if (RadioBoxExampleType.STRING.equals((Object)this.exampleType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfStringsMyBeanExample());
        } else if (RadioBoxExampleType.ENUM.equals((Object)this.exampleType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfEnumsMyBeanExample());
            codeExamples.add((AbstractCodeExample)new RadioBoxFooTypeExample());
        } else if (RadioBoxExampleType.OBJECT.equals((Object)this.exampleType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfObjectsMyBeanExample());
            codeExamples.add((AbstractCodeExample)new RadioBoxFooExample());
        } else if (RadioBoxExampleType.TEMPLATE.equals((Object)this.exampleType)) {
            codeExamples.add((AbstractCodeExample)new TreeBoxListOfEpisodesJavaExample("radiobox.demo"));
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesJavaExample("radiobox.demo"));
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfTemplatesCssExample());
        }
        this.generateDemoCSS(codeExamples);
    }

    public String getReadableValue() {
        if (super.getValue() != null) {
            if (super.getValue() instanceof Foo) {
                return ((Foo)super.getValue()).getValue();
            }
            if (super.getValue() instanceof FooType) {
                return ((FooType)super.getValue()).getLabel();
            }
            if (super.getValue() instanceof SelectItem) {
                return ((SelectItem)super.getValue()).getLabel();
            }
            if (super.getValue() instanceof Episode) {
                return ((Episode)super.getValue()).getTitle();
            }
            return (String)super.getValue();
        }
        return "(item is null)";
    }

    public List getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$RadioBoxExampleType[this.exampleType.ordinal()]) {
            case 1: {
                return this.foos;
            }
            case 2: {
                return Arrays.asList(FooType.values());
            }
            case 3: {
                return Episodes.EPISODES.subList(0, 3);
            }
        }
        return this.strings;
    }

    public List<SelectItem> getExampleTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (RadioBoxExampleType type : RadioBoxExampleType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getRadioLayoutTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (RadioBoxLayoutType type : RadioBoxLayoutType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public RadioBoxExampleType getExampleType() {
        return this.exampleType;
    }

    public void setExampleType(RadioBoxExampleType exampleType) {
        this.exampleType = exampleType;
    }

    public RadioBoxLayoutType getRadioBoxLayoutType() {
        return this.radioBoxLayoutType;
    }

    public void setRadioBoxLayoutType(RadioBoxLayoutType radioBoxLayoutType) {
        this.radioBoxLayoutType = radioBoxLayoutType;
    }

    private void initFoos() {
        this.foos.add(new Foo("fooKey1", "fooValue1"));
        this.foos.add(new Foo("fooKey2", "fooValue2"));
        this.foos.add(new Foo("fooKey3", "fooValue3"));
    }

    private void initStrings() {
        this.strings.add("Year 2000");
        this.strings.add("Year 2010");
        this.strings.add("Year 2020");
    }
}

