/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.container;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.container.RepeatExampleType;
import de.larmic.butterfaces.component.showcase.container.examples.SimpleRepeatBeanCodeExample;
import de.larmic.butterfaces.component.showcase.container.examples.SimpleRepeatListXhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.container.examples.StargateRepeatBeanCodeExample;
import de.larmic.butterfaces.component.showcase.container.examples.StargateRepeatListCssCodeExample;
import de.larmic.butterfaces.component.showcase.container.examples.StargateRepeatListXhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.CssCodeExample;
import de.larmic.butterfaces.component.showcase.table.DemoPojo;
import de.larmic.butterfaces.component.showcase.table.example.DemoPojoCodeExample;
import de.larmic.butterfaces.component.showcase.tree.Episode;
import de.larmic.butterfaces.component.showcase.tree.Episodes;
import de.larmic.butterfaces.component.showcase.tree.examples.stargate.TreeBoxEpisodesJavaExample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class RepeatShowcase
extends AbstractCodeShowcase
implements Serializable {
    private RepeatExampleType selectedExampleType = RepeatExampleType.STARGATE;
    private final List<DemoPojo> values = new ArrayList();

    public RepeatShowcase() {
        for (int i = 0; i < 123; ++i) {
            this.values.add(new DemoPojo((long)i, "a" + i, "b" + i));
        }
    }

    public void play() {
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        if (this.selectedExampleType == RepeatExampleType.SIMPLE) {
            codeExamples.add((AbstractCodeExample)new SimpleRepeatListXhtmlCodeExample(this.isRendered()));
            codeExamples.add((AbstractCodeExample)new SimpleRepeatBeanCodeExample());
            codeExamples.add((AbstractCodeExample)new DemoPojoCodeExample("repeat.demo"));
            CssCodeExample cssCodeExample = new CssCodeExample();
            cssCodeExample.addCss(".repeat-simple-list", new String[]{"max-height: 400px", "overflow: auto"});
            codeExamples.add((AbstractCodeExample)cssCodeExample);
        } else {
            codeExamples.add((AbstractCodeExample)new StargateRepeatListXhtmlCodeExample(this.isRendered()));
            codeExamples.add((AbstractCodeExample)new StargateRepeatBeanCodeExample());
            codeExamples.add((AbstractCodeExample)new TreeBoxEpisodesJavaExample("repeat.demo"));
            codeExamples.add((AbstractCodeExample)new StargateRepeatListCssCodeExample());
        }
    }

    public List<Episode> getValues() {
        return Episodes.EPISODES;
    }

    public List<DemoPojo> getDemoPojos() {
        return this.values;
    }

    public List<SelectItem> getExampleTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (RepeatExampleType type : RepeatExampleType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public RepeatExampleType getSelectedExampleType() {
        return this.selectedExampleType;
    }

    public void setSelectedExampleType(RepeatExampleType selectedExampleType) {
        this.selectedExampleType = selectedExampleType;
    }
}

