/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TempFileManager {
    public static final TempFileManager INSTANCE = new TempFileManager();
    private Set<File> registered = Collections.newSetFromMap(new ConcurrentHashMap());

    private TempFileManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> INSTANCE.close()));
    }

    public File newTempDirectory(String base, String ext) throws IOException {
        File tmp = File.createTempFile(base, ext);
        tmp.delete();
        tmp.mkdirs();
        tmp.deleteOnExit();
        this.register(tmp);
        return tmp;
    }

    public File newTempFile(String base, String ext) throws IOException {
        File tmp = File.createTempFile(base, ext);
        tmp.delete();
        tmp.deleteOnExit();
        this.register(tmp);
        return tmp;
    }

    private void register(File file) {
        this.registered.add(file);
    }

    private void close() {
        for (File file : this.registered) {
            this.deleteRecursively(file);
        }
    }

    private void deleteRecursively(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }
}

