/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.AbstractSingleModuleFinder;
import org.wildfly.swarm.bootstrap.util.Layout;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmBootstrapConf;

public class BootstrapModuleFinder
extends AbstractSingleModuleFinder {
    public static final String MODULE_NAME = "org.wildfly.swarm.bootstrap";
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.bootstrap");

    public BootstrapModuleFinder() {
        super(MODULE_NAME);
    }

    @Override
    public void buildModule(ModuleSpec.Builder builder, ModuleLoader delegateLoader) throws ModuleLoadException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading module");
        }
        try {
            if (Layout.getInstance().isUberJar()) {
                this.handleWildFlySwarmBootstrapConf(builder);
            }
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.modules")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.msc")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.shrinkwrap")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("javax.api")));
            HashSet<String> paths = new HashSet<String>();
            paths.add("org/wildfly/swarm/bootstrap/logging");
            paths.add("org/wildfly/swarm/bootstrap/util");
            paths.add("org/wildfly/swarm/bootstrap/modules");
            builder.addDependency(DependencySpec.createSystemDependencySpec(paths, true));
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
        catch (URISyntaxException e) {
            throw new ModuleLoadException(e);
        }
    }

    protected void handleWildFlySwarmBootstrapConf(ModuleSpec.Builder builder) throws IOException {
        InputStream bootstrapTxt;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading conf from META-INF/wildfly-swarm-bootstrap.conf");
        }
        if ((bootstrapTxt = this.getClass().getClassLoader().getResourceAsStream("META-INF/wildfly-swarm-bootstrap.conf")) != null) {
            WildFlySwarmBootstrapConf conf = new WildFlySwarmBootstrapConf(bootstrapTxt);
            conf.apply(builder);
        }
    }
}

