package de.larmic.butterfaces.component.showcase;

import java.io.Serializable;

/**
 * Contains butterfaces maven pom.xml informations. templating-maven-plugin is used in pom.xml.
 */
@javax.inject.Named
@javax.faces.view.ViewScoped
@SuppressWarnings("serial")
public class Version implements Serializable {

    private static final String VERSION = "2.1.0";
    private static final String GROUPID = "de.larmic.butterfaces";
    private static final String ARTIFACTID = "showcase";
    private static final String REVISION = "ff632a2482f6f4c90894d494f29ecf86a628d173";
    private static final String JBOSS = "10.0.0.Final";

    public String getVersion() {
        return VERSION;
    }

    public String getLastestReleaseVersion() {
        if (VERSION.endsWith("SNAPSHOT")) {
            final String version = VERSION.replaceAll("-SNAPSHOT", "");
            try {
                final String[] splitted = version.split("\\.");
                final String newMinorVersion = Integer.valueOf(splitted[splitted.length - 1]) - 1 + "";

                final StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < splitted.length - 1; i++) {
                    stringBuilder.append(splitted[i]);
                    stringBuilder.append(".");
                }
                stringBuilder.append(newMinorVersion);

                return stringBuilder.toString();
            } catch (NumberFormatException e) {
                return version;
            }
        }

        return VERSION;
    }

    public String getGroupId() {
        return GROUPID;
    }

    public String getArtifactId() {
        return ARTIFACTID;
    }

    public String getRevision() {
        return REVISION;
    }

    public String getJBossVersion() {
        return JBOSS;
    }
}