/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.radioBox;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.comboBox.Foo;
import de.larmic.butterfaces.component.showcase.comboBox.FooConverter;
import de.larmic.butterfaces.component.showcase.comboBox.FooType;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.radioBox.RadioBoxShowcase;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxFooExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxFooTypeExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfEnumsMyBeanExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfObjectsMyBeanExample;
import de.larmic.butterfaces.component.showcase.radioBox.examples.RadioBoxListOfStringsMyBeanExample;
import de.larmic.butterfaces.component.showcase.type.ComboBoxValueType;
import de.larmic.butterfaces.component.showcase.type.RadioBoxLayoutType;
import de.larmic.butterfaces.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class RadioBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private ComboBoxValueType comboBoxValueType = ComboBoxValueType.STRING;
    private RadioBoxLayoutType radioBoxLayoutType = RadioBoxLayoutType.LINE_DIRECTION;
    private final List<Foo> foos = new ArrayList();
    private final List<FooType> enums = new ArrayList();
    private final List<String> strings = new ArrayList();

    public RadioBoxShowcase() {
        this.initFoos();
        this.initStrings();
        this.initEnums();
    }

    protected Object initValue() {
        return null;
    }

    public Object getValue() {
        if (super.getValue() != null) {
            return super.getValue();
        }
        return "(item is null)";
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:radioBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"#{myBean.selectedValue}\"");
        xhtmlCodeExample.appendInnerContent("                    values=\"#{myBean.values}\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:radioBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        if (ComboBoxValueType.STRING.equals((Object)this.comboBoxValueType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfStringsMyBeanExample());
        } else if (ComboBoxValueType.ENUM.equals((Object)this.comboBoxValueType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfEnumsMyBeanExample());
            codeExamples.add((AbstractCodeExample)new RadioBoxFooTypeExample());
        } else if (ComboBoxValueType.OBJECT.equals((Object)this.comboBoxValueType)) {
            codeExamples.add((AbstractCodeExample)new RadioBoxListOfObjectsMyBeanExample());
            codeExamples.add((AbstractCodeExample)new RadioBoxFooExample());
        }
        this.generateDemoCSS(codeExamples);
    }

    public String getReadableValue() {
        if (super.getValue() != null) {
            if (super.getValue() instanceof Foo) {
                return ((Foo)super.getValue()).getValue();
            }
            if (super.getValue() instanceof FooType) {
                return ((FooType)super.getValue()).getLabel();
            }
            if (super.getValue() instanceof SelectItem) {
                return ((SelectItem)super.getValue()).getLabel();
            }
            return (String)super.getValue();
        }
        return "(item is null)";
    }

    public List getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$ComboBoxValueType[this.comboBoxValueType.ordinal()]) {
            case 1: {
                return this.foos;
            }
            case 2: {
                return this.enums;
            }
        }
        return this.strings;
    }

    public List<SelectItem> getComboBoxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ComboBoxValueType type : ComboBoxValueType.values()) {
            if (ComboBoxValueType.TEMPLATE.equals((Object)type)) continue;
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getRadioLayoutTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (RadioBoxLayoutType type : RadioBoxLayoutType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public ComboBoxValueType getComboBoxValueType() {
        return this.comboBoxValueType;
    }

    public void setComboBoxValueType(ComboBoxValueType comboBoxValueType) {
        this.comboBoxValueType = comboBoxValueType;
    }

    public RadioBoxLayoutType getRadioBoxLayoutType() {
        return this.radioBoxLayoutType;
    }

    public void setRadioBoxLayoutType(RadioBoxLayoutType radioBoxLayoutType) {
        this.radioBoxLayoutType = radioBoxLayoutType;
    }

    private void initFoos() {
        for (String key : FooConverter.fooMap.keySet()) {
            Foo foo = (Foo)FooConverter.fooMap.get(key);
            this.foos.add(foo);
        }
    }

    private void initEnums() {
        for (FooType fooType : FooType.values()) {
            this.enums.add(fooType);
        }
    }

    private void initStrings() {
        this.strings.add("Year 2000");
        this.strings.add("Year 2010");
        this.strings.add("Year 2020");
    }
}

