/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.tags;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.tags.ConfirmKeyType;
import de.larmic.butterfaces.component.showcase.tags.TagsShowcase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class TagsShowcase
extends AbstractInputShowcase
implements Serializable {
    private String placeholder = "Enter text...";
    private ConfirmKeyType selectedConfirmKeyType = ConfirmKeyType.DEFAULT;
    private boolean autoFocus;
    private boolean allowDuplicates;
    private boolean trimValue;
    private Integer maxTags;
    private Integer maxChars;

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:tags id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                allowDuplicates=\"" + this.allowDuplicates + "\"");
        xhtmlCodeExample.appendInnerContent("                maxTags=\"" + this.maxTags + "\"");
        xhtmlCodeExample.appendInnerContent("                maxChars=\"" + this.maxChars + "\"");
        xhtmlCodeExample.appendInnerContent("                confirmKeys=\"" + this.getConfirmKeys() + "\"");
        xhtmlCodeExample.appendInnerContent("                placeholder=\"" + this.getPlaceholder() + "\"");
        xhtmlCodeExample.appendInnerContent("                styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:tags>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<SelectItem> getConfirmKeyTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ConfirmKeyType type : ConfirmKeyType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isTrimValue() {
        return this.trimValue;
    }

    public void setTrimValue(boolean trimValue) {
        this.trimValue = trimValue;
    }

    public Integer getMaxTags() {
        return this.maxTags;
    }

    public void setMaxTags(Integer maxTags) {
        this.maxTags = maxTags;
    }

    public Integer getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(Integer maxChars) {
        this.maxChars = maxChars;
    }

    public String getConfirmKeys() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$tags$ConfirmKeyType[this.selectedConfirmKeyType.ordinal()]) {
            case 1: {
                return "44";
            }
            case 2: {
                return "13";
            }
            case 3: {
                return "32";
            }
        }
        return null;
    }

    public ConfirmKeyType getSelectedConfirmKeyType() {
        return this.selectedConfirmKeyType;
    }

    public void setSelectedConfirmKeyType(ConfirmKeyType selectedConfirmKeyType) {
        this.selectedConfirmKeyType = selectedConfirmKeyType;
    }
}

