/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.maskedText;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.maskedText.InputMaskType;
import de.larmic.butterfaces.component.showcase.maskedText.MaskedTextShowcase;
import de.larmic.butterfaces.component.showcase.text.FacetType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class MaskedTextShowcase
extends AbstractInputShowcase
implements Serializable {
    private FacetType selectedFacetType = FacetType.NONE;
    private InputMaskType selectedInputMaskType = null;
    private String placeholder = "Enter text...";
    private String type;
    private String pattern;
    private String min;
    private String max;
    private boolean autoFocus;
    private String inputMask;
    private String dataInputMask;

    @PostConstruct
    public void init() {
        this.setSelectedInputMaskType(InputMaskType.PHONE);
    }

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = this.selectedInputMaskType == InputMaskType.PHONE ? new XhtmlCodeExample(false) : new XhtmlCodeExample(false, true);
        xhtmlCodeExample.appendInnerContent("        <b:maskedText id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                      label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                      value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                      placeholder=\"" + this.getPlaceholder() + "\"");
        xhtmlCodeExample.appendInnerContent("                      type=\"" + this.getType() + "\"");
        xhtmlCodeExample.appendInnerContent("                      pattern=\"" + this.getPattern() + "\"");
        xhtmlCodeExample.appendInnerContent("                      min=\"" + this.getMin() + "\"");
        xhtmlCodeExample.appendInnerContent("                      max=\"" + this.getMax() + "\"");
        xhtmlCodeExample.appendInnerContent("                      styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                      readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                      required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                      disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                      autoFocus=\"" + this.isAutoFocus() + "\"");
        if (this.selectedInputMaskType == InputMaskType.PHONE) {
            xhtmlCodeExample.appendInnerContent("                      maskedInput=\"" + this.inputMask + "\"");
        }
        if (this.selectedInputMaskType == InputMaskType.CURRENCY_BY_DATA) {
            xhtmlCodeExample.appendInnerContent("                      p:data-inputmask=\"" + this.dataInputMask + "\"");
        }
        xhtmlCodeExample.appendInnerContent("                      rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        if (this.selectedFacetType == FacetType.INPUT_GROUP_ADDON) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-addon-left\">");
            xhtmlCodeExample.appendInnerContent("                Left input-group-addon");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-addon-right\">");
            xhtmlCodeExample.appendInnerContent("                Right input-group-addon");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        } else if (this.selectedFacetType == FacetType.INPUT_GROUP_BTN) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-btn-left\">");
            xhtmlCodeExample.appendInnerContent("                <button type=\"button\" class=\"btn btn-default\">");
            xhtmlCodeExample.appendInnerContent("                     Go!");
            xhtmlCodeExample.appendInnerContent("                 </button>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-btn-right\">");
            xhtmlCodeExample.appendInnerContent("                <button type=\"button\" class=\"btn btn-default\"");
            xhtmlCodeExample.appendInnerContent("                        dropdown-toggle\"");
            xhtmlCodeExample.appendInnerContent("                        data-toggle=\"dropdown\"");
            xhtmlCodeExample.appendInnerContent("                        aria-expanded=\"false\">");
            xhtmlCodeExample.appendInnerContent("                     Action <span class=\"caret\"></span>");
            xhtmlCodeExample.appendInnerContent("                 </button>");
            xhtmlCodeExample.appendInnerContent("                 <ul class=\"dropdown-menu dropdown-menu-right\" role=\"menu\">");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Action</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Another action</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Something else here</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li class=\"divider\"></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Separated link</a></li>");
            xhtmlCodeExample.appendInnerContent("                 </ul>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:maskedText>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<SelectItem> getAvailableFacetTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (FacetType type : FacetType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getInputMaskTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (InputMaskType type : InputMaskType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public FacetType getSelectedFacetType() {
        return this.selectedFacetType;
    }

    public void setSelectedFacetType(FacetType selectedFacetType) {
        this.selectedFacetType = selectedFacetType;
    }

    public InputMaskType getSelectedInputMaskType() {
        return this.selectedInputMaskType;
    }

    public void setSelectedInputMaskType(InputMaskType selectedInputMaskType) {
        this.selectedInputMaskType = selectedInputMaskType;
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$maskedText$InputMaskType[selectedInputMaskType.ordinal()]) {
            case 1: {
                this.inputMask = "'(99) 9999[9]-9999'";
                this.dataInputMask = null;
                break;
            }
            case 2: {
                this.inputMask = null;
                this.dataInputMask = "'alias': 'numeric', 'groupSeparator': ',', 'autoGroup': true, 'digits': 2, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'";
            }
        }
    }

    public String getInputMask() {
        return this.inputMask;
    }

    public String getDataInputMask() {
        return this.dataInputMask;
    }
}

