/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.container;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.container.LabeledContainerExampleType;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class LabeledContainerShowcase
extends AbstractCodeShowcase
implements Serializable {
    private LabeledContainerExampleType exampleType = LabeledContainerExampleType.TEXT;
    private String label = "label";
    private boolean hideLabel;

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("\n        <b:labeledContainer id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                            label=\"" + this.label + "\"");
        xhtmlCodeExample.appendInnerContent("                            hideLabel=\"" + this.hideLabel + "\"");
        xhtmlCodeExample.appendInnerContent("                            rendered=\"" + this.isRendered() + "\">");
        if (this.exampleType == LabeledContainerExampleType.TEXT) {
            xhtmlCodeExample.appendInnerContent("            Lorem ipsum dolor sit amet, consectetuer ...");
        } else if (this.exampleType == LabeledContainerExampleType.LINK) {
            xhtmlCodeExample.appendInnerContent("            <b:commandLink value=\"click me\" />");
        } else if (this.exampleType == LabeledContainerExampleType.SECTION) {
            xhtmlCodeExample.appendInnerContent("            <b:section label=\"demo\">");
            xhtmlCodeExample.appendInnerContent("                Lorem ipsum dolor sit amet, consectetuer ...");
            xhtmlCodeExample.appendInnerContent("            </b:section>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:labeledContainer>");
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
    }

    public List<SelectItem> getExampleTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (LabeledContainerExampleType type : LabeledContainerExampleType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public boolean isHideLabel() {
        return this.hideLabel;
    }

    public void setHideLabel(boolean hideLabel) {
        this.hideLabel = hideLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LabeledContainerExampleType getExampleType() {
        return this.exampleType;
    }

    public void setExampleType(LabeledContainerExampleType exampleType) {
        this.exampleType = exampleType;
    }
}

