/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import java.io.Serializable;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class TextAreaShowcase
extends AbstractInputShowcase
implements Serializable {
    private Integer maxLength;
    private Boolean expandable;
    private boolean autoFocus;
    private String placeholder = "Enter text...";

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:textArea id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    tooltip=\"" + this.getTooltip() + "\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                    placeholder=\"" + this.placeholder + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        if (this.getMaxLength() != null) {
            xhtmlCodeExample.appendInnerContent("                    maxLength=\"" + this.getMaxLength() + "\"");
        }
        if (Boolean.TRUE.equals(this.getExpandable())) {
            xhtmlCodeExample.appendInnerContent("                    expandable=\"" + this.getExpandable() + "\"");
        }
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:textArea>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getExpandable() {
        return this.expandable;
    }

    public void setExpandable(Boolean expandable) {
        this.expandable = expandable;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }
}

