/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.comboBox;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.comboBox.ComboBoxShowcase;
import de.larmic.butterfaces.component.showcase.comboBox.Episode;
import de.larmic.butterfaces.component.showcase.comboBox.EpisodeConverter;
import de.larmic.butterfaces.component.showcase.comboBox.FacetType;
import de.larmic.butterfaces.component.showcase.comboBox.Foo;
import de.larmic.butterfaces.component.showcase.comboBox.FooConverter;
import de.larmic.butterfaces.component.showcase.comboBox.FooType;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.CssCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.type.ComboBoxValueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class ComboBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private ComboBoxValueType comboBoxValueType = ComboBoxValueType.TEMPLATE;
    private FacetType selectedFacetType = FacetType.NONE;
    private boolean autoFocus;
    private final List<SelectItem> foos = new ArrayList();
    private final List<SelectItem> enums = new ArrayList();
    private final List<SelectItem> strings = new ArrayList();
    private Episode chosenEpisode;

    public ComboBoxShowcase() {
        this.initFoos();
        this.initStrings();
        this.initEnums();
    }

    protected Object initValue() {
        return null;
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = this.createXhtmlExample();
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        if (this.comboBoxValueType == ComboBoxValueType.TEMPLATE) {
            codeExamples.add((AbstractCodeExample)this.createEpisodeJavaCodeExample());
            codeExamples.add((AbstractCodeExample)this.createEpisodeCssCodeExample());
        }
        this.generateDemoCSS(codeExamples);
    }

    private JavaCodeExample createEpisodeJavaCodeExample() {
        JavaCodeExample javaCodeExample = new JavaCodeExample("Episode.java", "episode", "combobox.demo", "Episode", false);
        javaCodeExample.appendInnerContent("    private int numberInSeries;");
        javaCodeExample.appendInnerContent("    private String title;");
        javaCodeExample.appendInnerContent("    private String writtenBy;");
        javaCodeExample.appendInnerContent("    private String originalAirDate;");
        javaCodeExample.appendInnerContent("    private String image;");
        javaCodeExample.appendInnerContent("    // [...] getter + setter");
        return javaCodeExample;
    }

    private CssCodeExample createEpisodeCssCodeExample() {
        CssCodeExample cssCodeExample = new CssCodeExample();
        cssCodeExample.addCss(".stargateEpisodeItem", new String[]{"display: flex", "align-items: stretch"});
        cssCodeExample.addCss(".stargateEpisodeItem img", new String[]{"height: 75px"});
        cssCodeExample.addCss(".stargateEpisodeItem h4", new String[]{"font-size: 16px", "margin-top: 5px"});
        cssCodeExample.addCss(".stargateEpisodeItem .stargateEpisodeDetails", new String[]{"font-size: 12px", "margin-left: 5px"});
        cssCodeExample.addCss(".stargateEpisodeItem .stargateEpisodeDetails > div", new String[]{"display: flex", "align-items: baseline"});
        cssCodeExample.addCss(".stargateEpisodeItem .stargateEpisodeDetails label", new String[]{"width: 80px", "font-weight: bold"});
        cssCodeExample.addCss(".stargateEpisodeItem .stargateEpisodeDetails span", new String[]{"flex: 1"});
        return cssCodeExample;
    }

    private XhtmlCodeExample createXhtmlExample() {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:comboBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    tooltip=\"" + this.getTooltip() + "\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "change");
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        if (this.selectedFacetType == FacetType.INPUT_GROUP_ADDON) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-addon-left\">");
            xhtmlCodeExample.appendInnerContent("                Left input-group-addon");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        } else if (this.selectedFacetType == FacetType.INPUT_GROUP_BTN) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-btn-left\">");
            xhtmlCodeExample.appendInnerContent("                <button type=\"button\" class=\"btn btn-default\">");
            xhtmlCodeExample.appendInnerContent("                     Go!");
            xhtmlCodeExample.appendInnerContent("                 </button>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        if (this.comboBoxValueType == ComboBoxValueType.STRING) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"#{null}\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Choose one...\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2000\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2000\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2010\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2010\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2020\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2020\"/>");
        } else if (this.comboBoxValueType == ComboBoxValueType.ENUM) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItems value=\"#{bean.fooEnums}\"/>");
        } else if (this.comboBoxValueType == ComboBoxValueType.OBJECT) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItems value=\"#{bean.fooObjects}\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:converter converterId=\"fooConverter\"/>    ");
        } else if (this.comboBoxValueType == ComboBoxValueType.TEMPLATE) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItems value=\"#{bean.episodes}\"");
            xhtmlCodeExample.appendInnerContent("                           var=\"episode\"");
            xhtmlCodeExample.appendInnerContent("                           itemLabel=\"#{episode.title}\"");
            xhtmlCodeExample.appendInnerContent("                           itemValue=\"#{episode}\"");
            xhtmlCodeExample.appendInnerContent("                           noSelectionValue=\"please choose\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"template\">");
            xhtmlCodeExample.appendInnerContent("                 <div class=\"stargateEpisodeItem\">");
            xhtmlCodeExample.appendInnerContent("                      <img class=\"stargateEpisodeImg\" src=\"{{image}}\" alt=\"{{title}}\"/>");
            xhtmlCodeExample.appendInnerContent("                      <div class=\"stargateEpisodeDetails\">");
            xhtmlCodeExample.appendInnerContent("                           <h4>{{title}} <small>({{originalAirDate}})</small></h4>");
            xhtmlCodeExample.appendInnerContent("                           <div>");
            xhtmlCodeExample.appendInnerContent("                                <label>Episode:</label>");
            xhtmlCodeExample.appendInnerContent("                                <span>");
            xhtmlCodeExample.appendInnerContent("                                     No. {{numberInSeries}} of Stargate - Kommando SG-1, ");
            xhtmlCodeExample.appendInnerContent("                                     Season 1</span>");
            xhtmlCodeExample.appendInnerContent("                                </span>");
            xhtmlCodeExample.appendInnerContent("                           </div>");
            xhtmlCodeExample.appendInnerContent("                           <div>");
            xhtmlCodeExample.appendInnerContent("                                <label>written by:</label>");
            xhtmlCodeExample.appendInnerContent("                                <span>{{writtenBy}}</span>");
            xhtmlCodeExample.appendInnerContent("                           </div>");
            xhtmlCodeExample.appendInnerContent("                      </div>");
            xhtmlCodeExample.appendInnerContent("                 </div>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:comboBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        return xhtmlCodeExample;
    }

    public Object getValue() {
        return super.getValue() != null ? super.getValue() : "(item is null)";
    }

    public String getReadableValue() {
        if (super.getValue() != null) {
            if (super.getValue() instanceof Foo) {
                return ((Foo)super.getValue()).getValue();
            }
            if (super.getValue() instanceof FooType) {
                return ((FooType)super.getValue()).label;
            }
            if (super.getValue() instanceof Episode) {
                return ((Episode)super.getValue()).getTitle();
            }
            return (String)super.getValue();
        }
        return "(item is null)";
    }

    public List<SelectItem> getAvailableFacetTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (FacetType type : FacetType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$ComboBoxValueType[this.comboBoxValueType.ordinal()]) {
            case 1: {
                return this.foos;
            }
            case 2: {
                return this.enums;
            }
        }
        return this.strings;
    }

    public boolean isConverterActive() {
        return this.comboBoxValueType == ComboBoxValueType.OBJECT;
    }

    public List<SelectItem> getComboBoxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ComboBoxValueType type : ComboBoxValueType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public ComboBoxValueType getComboBoxValueType() {
        return this.comboBoxValueType;
    }

    public void setComboBoxValueType(ComboBoxValueType comboBoxValueType) {
        this.comboBoxValueType = comboBoxValueType;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    private void initFoos() {
        this.foos.add(new SelectItem(null, "Choose one..."));
        for (String key : FooConverter.fooMap.keySet()) {
            Foo foo = (Foo)FooConverter.fooMap.get(key);
            this.foos.add(new SelectItem((Object)foo, foo.getKey()));
        }
    }

    private void initEnums() {
        this.enums.add(new SelectItem(null, "Choose one..."));
        for (FooType fooType : FooType.values()) {
            this.enums.add(new SelectItem((Object)fooType.label));
        }
    }

    private void initStrings() {
        this.strings.add(new SelectItem(null, "Choose one..."));
        this.strings.add(new SelectItem((Object)"2000", "Year 2000"));
        this.strings.add(new SelectItem((Object)"2010", "Year 2010"));
        this.strings.add(new SelectItem((Object)"2020", "Year 2020"));
    }

    public FacetType getSelectedFacetType() {
        return this.selectedFacetType;
    }

    public void setSelectedFacetType(FacetType selectedFacetType) {
        this.selectedFacetType = selectedFacetType;
    }

    public List<Episode> getEpisodes() {
        return EpisodeConverter.EPISODES;
    }

    public Episode getChosenEpisode() {
        return this.chosenEpisode;
    }

    public void setChosenEpisode(Episode chosenEpisode) {
        this.chosenEpisode = chosenEpisode;
    }
}

