/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.text;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.text.FacetType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class SecretShowcase
extends AbstractInputShowcase
implements Serializable {
    private FacetType selectedFacetType = FacetType.NONE;
    private String placeholder = "Enter text...";
    private boolean autoFocus;

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:secret id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                  label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                  hideLabel=\"" + this.isHideLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                  value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                  placeholder=\"" + this.getPlaceholder() + "\"");
        xhtmlCodeExample.appendInnerContent("                  styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                  readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                  required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                  disabled=\"" + this.isDisabled() + "\"");
        xhtmlCodeExample.appendInnerContent("                  autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                  rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        if (StringUtils.isNotEmpty((String)this.getTooltip())) {
            xhtmlCodeExample.appendInnerContent("            <b:tooltip>");
            xhtmlCodeExample.appendInnerContent("                " + this.getTooltip());
            xhtmlCodeExample.appendInnerContent("            </b:tooltip>");
        }
        if (this.selectedFacetType == FacetType.INPUT_GROUP_ADDON) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-addon-left\">");
            xhtmlCodeExample.appendInnerContent("                Left input-group-addon");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-addon-right\">");
            xhtmlCodeExample.appendInnerContent("                Right input-group-addon");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        } else if (this.selectedFacetType == FacetType.INPUT_GROUP_BTN) {
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-btn-left\">");
            xhtmlCodeExample.appendInnerContent("                <button type=\"button\" class=\"btn btn-default\">");
            xhtmlCodeExample.appendInnerContent("                     Go!");
            xhtmlCodeExample.appendInnerContent("                 </button>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
            xhtmlCodeExample.appendInnerContent("            <f:facet name=\"input-group-btn-right\">");
            xhtmlCodeExample.appendInnerContent("                <button type=\"button\" class=\"btn btn-default\"");
            xhtmlCodeExample.appendInnerContent("                        dropdown-toggle\"");
            xhtmlCodeExample.appendInnerContent("                        data-toggle=\"dropdown\"");
            xhtmlCodeExample.appendInnerContent("                        aria-expanded=\"false\">");
            xhtmlCodeExample.appendInnerContent("                     Action <span class=\"caret\"></span>");
            xhtmlCodeExample.appendInnerContent("                 </button>");
            xhtmlCodeExample.appendInnerContent("                 <ul class=\"dropdown-menu dropdown-menu-right\" role=\"menu\">");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Action</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Another action</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Something else here</a></li>");
            xhtmlCodeExample.appendInnerContent("                     <li class=\"divider\"></li>");
            xhtmlCodeExample.appendInnerContent("                     <li><a href=\"#\">Separated link</a></li>");
            xhtmlCodeExample.appendInnerContent("                 </ul>");
            xhtmlCodeExample.appendInnerContent("            </f:facet>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:secret>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<SelectItem> getAvailableFacetTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (FacetType type : FacetType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public FacetType getSelectedFacetType() {
        return this.selectedFacetType;
    }

    public void setSelectedFacetType(FacetType selectedFacetType) {
        this.selectedFacetType = selectedFacetType;
    }
}

