/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.calendar;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.calendar.CalendarIconType;
import de.larmic.butterfaces.component.showcase.calendar.CalendarShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class CalendarShowcase
extends AbstractInputShowcase
implements Serializable {
    private CalendarIconType selectedIconType = CalendarIconType.DEFAULT;
    private String glyphiconDate = null;
    private String glyphiconTime = null;
    private String glyphiconUp = null;
    private String glyphiconDown = null;
    private String placeholder = "Enter date or click icon...";
    private boolean autoFocus;
    private boolean pickDate = true;
    private boolean pickTime = true;
    private boolean sideBySise = false;
    private String language = "en";

    protected Object initValue() {
        return null;
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        boolean useFontAwesome = this.selectedIconType == CalendarIconType.AWESOME;
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(useFontAwesome);
        xhtmlCodeExample.appendInnerContent("        <b:calendar id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    tooltip=\"" + this.getTooltip() + "\"");
        xhtmlCodeExample.appendInnerContent("                    pickDate=\"" + this.pickDate + "\"");
        xhtmlCodeExample.appendInnerContent("                    pickTime=\"" + this.pickTime + "\"");
        xhtmlCodeExample.appendInnerContent("                    sideBySide=\"" + this.sideBySise + "\"");
        xhtmlCodeExample.appendInnerContent("                    glyphiconDate=\"" + this.glyphiconDate + "\"");
        xhtmlCodeExample.appendInnerContent("                    glyphiconTime=\"" + this.glyphiconTime + "\"");
        xhtmlCodeExample.appendInnerContent("                    glyphiconUp=\"" + this.glyphiconUp + "\"");
        xhtmlCodeExample.appendInnerContent("                    glyphiconDown=\"" + this.glyphiconDown + "\"");
        xhtmlCodeExample.appendInnerContent("                    placeholder=\"" + this.getPlaceholder() + "\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (this.isValidation()) {
            xhtmlCodeExample.appendInnerContent("            <f:validateLength minimum=\"2\" maximum=\"10\"/>");
        }
        xhtmlCodeExample.appendInnerContent("        </b:calendar>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public List<SelectItem> getCalendarIconTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (CalendarIconType type : CalendarIconType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public boolean isPickDate() {
        return this.pickDate;
    }

    public void setPickDate(boolean pickDate) {
        this.pickDate = pickDate;
    }

    public boolean isPickTime() {
        return this.pickTime;
    }

    public void setPickTime(boolean pickTime) {
        this.pickTime = pickTime;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public CalendarIconType getSelectedIconType() {
        return this.selectedIconType;
    }

    public void setSelectedIconType(CalendarIconType selectedIconType) {
        this.selectedIconType = selectedIconType;
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$calendar$CalendarIconType[selectedIconType.ordinal()]) {
            case 1: {
                this.glyphiconDate = null;
                this.glyphiconTime = null;
                this.glyphiconUp = null;
                this.glyphiconDown = null;
                break;
            }
            case 2: {
                this.glyphiconDate = "fa fa-calendar";
                this.glyphiconTime = "fa fa-clock-o";
                this.glyphiconUp = "fa fa-chevron-up";
                this.glyphiconDown = "fa fa-chevron-down";
            }
        }
    }

    public String getGlyphiconTime() {
        return this.glyphiconTime;
    }

    public String getGlyphiconDate() {
        return this.glyphiconDate;
    }

    public String getGlyphiconUp() {
        return this.glyphiconUp;
    }

    public String getGlyphiconDown() {
        return this.glyphiconDown;
    }

    public boolean isSideBySise() {
        return this.sideBySise;
    }

    public void setSideBySise(boolean sideBySise) {
        this.sideBySise = sideBySise;
    }
}

