/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcaseSingleCodeComponent;
import de.larmic.butterfaces.component.showcase.PrettyPrintShowcaseSingleCodeComponent;
import de.larmic.butterfaces.component.showcase.type.PrettyPrintType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class PrettyPrintShowcaseSingleCodeComponent
extends AbstractInputShowcaseSingleCodeComponent
implements Serializable {
    private PrettyPrintType prettyPrintType = PrettyPrintType.HTML;

    protected Object initValue() {
        return "value";
    }

    public String getReadableValue() {
        return (String)this.getValue();
    }

    public String getContent() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$PrettyPrintType[this.prettyPrintType.ordinal()]) {
            case 1: {
                return this.getJavaExample();
            }
            case 2: {
                return this.getXmlExample();
            }
        }
        return this.getHtmlExample();
    }

    public String getLanguage() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$PrettyPrintType[this.prettyPrintType.ordinal()]) {
            case 1: {
                return "lang-java";
            }
            case 2: {
                return "lang-xml";
            }
        }
        return "lang-html";
    }

    public List<SelectItem> getPrettyPrintTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (PrettyPrintType type : PrettyPrintType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public String getXHtml() {
        StringBuilder sb = new StringBuilder();
        this.addXhtmlStart(sb);
        sb.append("        <b:prettyprint id=\"input\"\n");
        this.appendString("language", this.getLanguage(), sb);
        this.appendBoolean("rendered", this.isRendered(), sb, true);
        if (this.prettyPrintType == PrettyPrintType.HTML) {
            sb.append("           #{myBean.htmlContent}\n");
        } else if (this.prettyPrintType == PrettyPrintType.JAVA) {
            sb.append("           #{myBean.javaContent}\n");
        } else {
            sb.append("           #{myBean.xmlContent}\n");
        }
        sb.append("        </b:prettyprint>");
        this.createOutputXhtml(sb);
        this.addXhtmlEnd(sb);
        return sb.toString();
    }

    protected String getEmptyDistanceString() {
        return "                       ";
    }

    private String getJavaExample() {
        StringBuilder java = new StringBuilder();
        java.append("public class HelloWorld {\n\n");
        java.append("    public static void main(String[ ] args) {\n");
        java.append("        System.out.println(\"Hello World!\");\n");
        java.append("    }\n\n");
        java.append("}\n");
        return java.toString();
    }

    private String getXmlExample() {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        xml.append("<root>\n");
        xml.append("    <title>Hello World!</title>\n");
        xml.append("</root>\n");
        return xml.toString();
    }

    private String getHtmlExample() {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
        html.append("      xmlns:h=\"http://xmlns.jcp.org/jsf/html\"\n");
        html.append("      xmlns:b=\"http://butterfaces.larmic.de/components\">\n");
        html.append("<h:head />\n");
        html.append("<body>\n");
        html.append("   <form>\n");
        html.append("      Hello World!\n");
        html.append("   </form>\n");
        html.append("</body>\n");
        html.append("</html>");
        return html.toString();
    }

    public PrettyPrintType getPrettyPrintType() {
        return this.prettyPrintType;
    }

    public void setPrettyPrintType(PrettyPrintType prettyPrintType) {
        this.prettyPrintType = prettyPrintType;
    }
}

