/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import java.io.Serializable;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class CheckBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private String description = "some description";
    private boolean autoFocus;

    protected Object initValue() {
        return false;
    }

    public String getReadableValue() {
        return (Boolean)this.getValue() != false ? "Ja" : "Nein";
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:checkBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    description=\"" + this.description + "\"");
        xhtmlCodeExample.appendInnerContent("                    tooltip=\"" + this.getTooltip() + "\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        xhtmlCodeExample.appendInnerContent("        </b:checkBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        this.generateDemoCSS(codeExamples);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }
}

