/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.CssCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.type.AjaxType;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

public abstract class AbstractInputShowcase
extends AbstractCodeShowcase {
    protected static final String DEFAULT_NUMBER_PLACEHOLDER = "Enter number...";
    protected static final String DEFAULT_TEXT_PLACEHOLDER = "Enter text...";
    private Object value;
    private String label = "label";
    private String tooltip = "tooltip";
    private boolean readonly;
    private boolean required;
    private boolean validation;
    private boolean hideLabel;
    private AjaxType ajaxType = AjaxType.NONE;
    private String styleClass = null;

    public AbstractInputShowcase() {
        this.value = this.initValue();
    }

    protected abstract Object initValue();

    public abstract String getReadableValue();

    public boolean isAjax() {
        return AjaxType.NONE != this.getAjaxType();
    }

    public List<SelectItem> getAjaxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (AjaxType type : AjaxType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getStyleClasses() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem(null, "default (null)"));
        items.add(new SelectItem((Object)"demo-big-label", "demo-big-label"));
        return items;
    }

    public void addAjaxTag(XhtmlCodeExample codeExample, String event) {
        if (this.isAjax()) {
            String execute = AjaxType.THIS == this.ajaxType ? "@this" : "input";
            codeExample.appendInnerContent("            <f:ajax event=\"" + event + "\"  execute=\"" + execute + "\" render=\"output\"/>");
        }
    }

    public void addOutputExample(XhtmlCodeExample codeExample) {
        if (this.isAjax()) {
            codeExample.appendInnerContent("\n        <h:outputText id=\"output\" value=\"" + this.getValue() + "\"/>");
        }
    }

    public void submit() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public AjaxType getAjaxType() {
        return this.ajaxType;
    }

    public void setAjaxType(AjaxType ajax) {
        this.ajaxType = ajax;
    }

    public boolean isHideLabel() {
        return this.hideLabel;
    }

    public void setHideLabel(boolean hideLabel) {
        this.hideLabel = hideLabel;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    protected void generateDemoCSS(List<AbstractCodeExample> codeExamples) {
        if (StringUtils.isNotEmpty((String)this.getStyleClass())) {
            CssCodeExample cssCodeExample = new CssCodeExample();
            cssCodeExample.addCss(".demo-big-label .butter-component-label", new String[]{"width: 250px;"});
            cssCodeExample.addCss(".demo-big-label .butter-component-value", new String[]{"width: calc(100% - 250px);"});
            codeExamples.add((AbstractCodeExample)cssCodeExample);
        }
    }
}

