/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.waitingpanel;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import java.io.Serializable;
import java.util.List;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class WaitingPanelShowcase
extends AbstractCodeShowcase
implements Serializable {
    private int delayInMillis = 500;

    public void doWaitingClick() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:waitingPanel id=\"waiting\"");
        xhtmlCodeExample.appendInnerContent("                        delay=\"" + this.delayInMillis + "\"");
        xhtmlCodeExample.appendInnerContent("                        rendered\"" + this.isRendered() + "\" />\n", true);
        xhtmlCodeExample.appendInnerContent("        <h:commandLink styleClass=\"btn btn-success\"");
        xhtmlCodeExample.appendInnerContent("                       action=\"#{myBean.waitForFiveSeconds}>\"");
        xhtmlCodeExample.appendInnerContent("            <!-- ajax tag is needed because waiting panel component");
        xhtmlCodeExample.appendInnerContent("                 s used ajax status to open and close overlay -->");
        xhtmlCodeExample.appendInnerContent("            <f:ajax />");
        xhtmlCodeExample.appendInnerContent("        </h:commandLink>");
        JavaCodeExample javaCodeExample = new JavaCodeExample("waiting.demo", "MyBean", true);
        javaCodeExample.appendInnerContent("    public void waitForFiveSeconds() {\n");
        javaCodeExample.appendInnerContent("        try {\n");
        javaCodeExample.appendInnerContent("            Thread.sleep(5000);\n");
        javaCodeExample.appendInnerContent("        } catch (InterruptedException e) {\n");
        javaCodeExample.appendInnerContent("            // this error is not ok...\n");
        javaCodeExample.appendInnerContent("        }\n");
        javaCodeExample.appendInnerContent("    }\n\n");
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)javaCodeExample);
    }

    public int getDelayInMillis() {
        return this.delayInMillis;
    }

    public void setDelayInMillis(int delayInMillis) {
        this.delayInMillis = delayInMillis;
    }
}

