/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.tree;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.JavaCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.tree.SelectionAjaxType;
import de.larmic.butterfaces.component.showcase.tree.TreeIconType;
import de.larmic.butterfaces.event.TreeNodeSelectionEvent;
import de.larmic.butterfaces.event.TreeNodeSelectionListener;
import de.larmic.butterfaces.model.tree.DefaultNodeImpl;
import de.larmic.butterfaces.model.tree.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class TreeShowcase
extends AbstractCodeShowcase
implements Serializable,
TreeNodeSelectionListener {
    public static final String FONT_AWESOME_MARKER = "font-awesome";
    private boolean hideRootNode = false;
    private SelectionAjaxType selectionAjaxType = SelectionAjaxType.AJAX;
    private TreeIconType selectedIconType = TreeIconType.IMAGE;
    private boolean allExpanded = true;
    private Node selectedNode;
    private String glyphicon;
    private String collapsingClass;
    private String expansionClass;

    public Node getTree() {
        DefaultNodeImpl secondFirstChild = this.createNode("secondFirstChild", "resources/images/folder-16.png", "glyphicon-folder-open");
        secondFirstChild.getSubNodes().add(this.createNode("secondFirstFirstChild", "resources/images/excel-16.png", "glyphicon-film"));
        DefaultNodeImpl firstChild = this.createNode("firstChild", "resources/images/excel-16.png", "glyphicon-film");
        DefaultNodeImpl secondChild = this.createNode("secondChild", "resources/images/folder-16.png", "glyphicon-folder-open");
        if (!this.allExpanded) {
            secondChild.setCollapsed(true);
        }
        DefaultNodeImpl secondThirdChild = this.createNode("secondThirdChild", "resources/images/folder-16.png", "glyphicon-folder-open");
        secondThirdChild.getSubNodes().add(this.createNode("thirdFirstChild", "resources/images/excel-16.png", "glyphicon-film"));
        secondThirdChild.getSubNodes().add(this.createNode("thirdSecondChild", "resources/images/word-16.png", "glyphicon-file"));
        secondThirdChild.getSubNodes().add(this.createNode("thirdThirdChild", "resources/images/ppt-16.png", "glyphicon-signal"));
        secondChild.getSubNodes().add(secondFirstChild);
        secondChild.getSubNodes().add(this.createNode("secondSecondChild", "resources/images/excel-16.png", "glyphicon-film"));
        secondChild.getSubNodes().add(secondThirdChild);
        secondChild.getSubNodes().add(this.createNode("secondFourthChild", "resources/images/excel-16.png", "glyphicon-film"));
        secondChild.getSubNodes().add(this.createNode("secondFifthChild", "resources/images/excel-16.png", "glyphicon-film"));
        DefaultNodeImpl rootNode = this.createNode("rootNode", "resources/images/folder-16.png", "glyphicon-folder-open");
        rootNode.getSubNodes().add(firstChild);
        rootNode.getSubNodes().add(secondChild);
        rootNode.getSubNodes().add(this.createNode("thirdChild", "resources/images/excel-16.png", "glyphicon-film"));
        return rootNode;
    }

    public void processValueChange(TreeNodeSelectionEvent event) {
        this.selectedNode = event.getNewValue();
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        codeExamples.add((AbstractCodeExample)this.createXhtmlCodeExample());
        codeExamples.add((AbstractCodeExample)this.createMyBeanCodeExample());
    }

    private JavaCodeExample createMyBeanCodeExample() {
        JavaCodeExample myBean = new JavaCodeExample("MyBean.java", "mybean", "tree.demo", "MyBean", true);
        if (this.selectionAjaxType != SelectionAjaxType.NONE) {
            myBean.addImport("import de.larmic.butterfaces.event.TreeNodeSelectionEvent");
            myBean.addImport("import de.larmic.butterfaces.event.TreeNodeSelectionListener");
        }
        myBean.addImport("import de.larmic.butterfaces.model.tree.Node");
        myBean.addImport("import de.larmic.butterfaces.model.tree.DefaultNodeImpl");
        myBean.addImport("import javax.faces.view.ViewScoped");
        myBean.addImport("import javax.inject.Named");
        if (this.selectionAjaxType != SelectionAjaxType.NONE) {
            myBean.addInterfaces("TreeNodeSelectionListener");
        }
        if (this.isAjaxRendered()) {
            myBean.appendInnerContent("    private Node selectedNode;\n");
        }
        myBean.appendInnerContent("    public Node getTreeModel() {");
        myBean.appendInnerContent("        final Node firstChild = new DefaultNodeImpl(\"firstChild\");");
        if (this.selectedIconType == TreeIconType.GLYPHICON) {
            myBean.appendInnerContent("        firstChild.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
        } else if (this.selectedIconType == TreeIconType.IMAGE) {
            myBean.appendInnerContent("        firstChild.setImageIcon(\"some/path/16.png\");");
        }
        myBean.appendInnerContent("        final Node secondChild = new DefaultNodeImpl(\"second\");");
        if (!this.allExpanded) {
            myBean.appendInnerContent("        secondChild.setCollapsed(true);");
        }
        if (this.selectedIconType == TreeIconType.GLYPHICON) {
            myBean.appendInnerContent("        secondChild.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
        } else if (this.selectedIconType == TreeIconType.IMAGE) {
            myBean.appendInnerContent("        secondChild.setImageIcon(\"some/path/16.png\");");
        }
        myBean.appendInnerContent("        secondChild.getSubNodes().add(new DefaultNodeImpl(\"...\"))");
        myBean.appendInnerContent("        ...");
        myBean.appendInnerContent("        final Node rootNode = new DefaultNodeImpl(\"rootNode\");");
        if (this.selectedIconType == TreeIconType.IMAGE) {
            myBean.appendInnerContent("        rootNode.setImageIcon(\"some/path/16.png\");");
        } else if (this.selectedIconType == TreeIconType.GLYPHICON) {
            myBean.appendInnerContent("        rootNode.setGlyphiconIcon(\"glyphicon glyphicon-folder-open\");");
        }
        myBean.appendInnerContent("        rootNode.getSubNodes().add(firstChild);");
        myBean.appendInnerContent("        rootNode.getSubNodes().add(secondChild);");
        myBean.appendInnerContent("        return rootNode;");
        myBean.appendInnerContent("    }\n");
        if (this.isAjaxRendered()) {
            myBean.appendInnerContent("    @Override");
            myBean.appendInnerContent("    public void processValueChange(final TreeNodeSelectionEvent event) {");
            myBean.appendInnerContent("        selectedNode = event.getNewValue();");
            myBean.appendInnerContent("    }\n");
            myBean.appendInnerContent("    public Node getSelectedNode() {");
            myBean.appendInnerContent("        return selectedNode;");
            myBean.appendInnerContent("    }");
        }
        return myBean;
    }

    public List<SelectItem> getAjaxSelectionTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (SelectionAjaxType type : SelectionAjaxType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getIconTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (TreeIconType type : TreeIconType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getGlyphicons() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)"bootstrap", "Butterfaces default"));
        items.add(new SelectItem((Object)"other-bootstrap", "other Bootstrap example"));
        items.add(new SelectItem((Object)FONT_AWESOME_MARKER, "Font-Awesome example"));
        return items;
    }

    private XhtmlCodeExample createXhtmlCodeExample() {
        boolean useFontAwesome = this.getGlyphicon() != null && FONT_AWESOME_MARKER.equals(this.getGlyphicon());
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(useFontAwesome);
        xhtmlCodeExample.appendInnerContent("        <b:tree id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                value=\"#{myBean.treeModel}\"");
        if (this.isAjaxRendered()) {
            xhtmlCodeExample.appendInnerContent("                nodeSelectionListener=\"#{myBean}\"");
        }
        xhtmlCodeExample.appendInnerContent("                collapsingClass=\"" + this.getExpansionClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                expansionClass=\"" + this.getCollapsingClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                hideRootNode=\"" + this.isHideRootNode() + "\"");
        xhtmlCodeExample.appendInnerContent("                rendered=\"" + this.isRendered() + "\">");
        if (this.isAjaxRendered()) {
            if (this.isAjaxDisabled()) {
                xhtmlCodeExample.appendInnerContent("            <f:ajax render=\"nodeTitle\" disabled=\"true\"/>");
            } else {
                xhtmlCodeExample.appendInnerContent("            <f:ajax render=\"nodeTitle\"/>");
            }
        }
        xhtmlCodeExample.appendInnerContent("        </b:tree>");
        if (this.isAjaxRendered()) {
            xhtmlCodeExample.appendInnerContent("\n    <h:panelGroup id=\"nodeTitle\">");
            xhtmlCodeExample.appendInnerContent("            <h:output value=\"#{myBean.selectedNode.title}\"");
            xhtmlCodeExample.appendInnerContent("                      rendered=\"#{not empty myBean.selectedNode}\"/>");
            xhtmlCodeExample.appendInnerContent("    <h:panelGroup/>");
        }
        return xhtmlCodeExample;
    }

    private DefaultNodeImpl createNode(String title, String icon, String glyphicon) {
        if (this.selectedIconType == TreeIconType.IMAGE) {
            return new DefaultNodeImpl(title, null, icon);
        }
        if (this.selectedIconType == TreeIconType.GLYPHICON) {
            DefaultNodeImpl node = new DefaultNodeImpl(title);
            node.setGlyphiconIcon("glyphicon " + glyphicon);
            return node;
        }
        return new DefaultNodeImpl(title);
    }

    public String getCollapsingClass() {
        return this.collapsingClass;
    }

    public String getExpansionClass() {
        return this.expansionClass;
    }

    public String getGlyphicon() {
        return this.glyphicon;
    }

    public void setGlyphicon(String glyphicon) {
        this.glyphicon = glyphicon;
        switch (glyphicon) {
            case "bootstrap": {
                this.collapsingClass = null;
                this.expansionClass = null;
                break;
            }
            case "other-bootstrap": {
                this.collapsingClass = "glyphicon glyphicon-resize-small";
                this.expansionClass = "glyphicon glyphicon-resize-full";
                break;
            }
            case "font-awesome": {
                this.collapsingClass = "fa fa-minus-square-o";
                this.expansionClass = "fa fa-plus-square-o";
            }
        }
    }

    public boolean isHideRootNode() {
        return this.hideRootNode;
    }

    public void setHideRootNode(boolean hideRootNode) {
        this.hideRootNode = hideRootNode;
    }

    public boolean isAjaxRendered() {
        return SelectionAjaxType.NONE != this.selectionAjaxType;
    }

    public boolean isAjaxDisabled() {
        return SelectionAjaxType.AJAX_DISABLED == this.selectionAjaxType;
    }

    public SelectionAjaxType getSelectionAjaxType() {
        return this.selectionAjaxType;
    }

    public void setSelectionAjaxType(SelectionAjaxType selectionAjaxType) {
        this.selectionAjaxType = selectionAjaxType;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public boolean isAllExpanded() {
        return this.allExpanded;
    }

    public void setAllExpanded(boolean allExpanded) {
        this.allExpanded = allExpanded;
    }

    public TreeIconType getSelectedIconType() {
        return this.selectedIconType;
    }

    public void setSelectedIconType(TreeIconType selectedIconType) {
        this.selectedIconType = selectedIconType;
    }
}

