/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase.example;

import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;

public class XhtmlCodeExample
extends AbstractCodeExample {
    private final StringBuilder innerContent = new StringBuilder();
    private final boolean useFontAwesome;

    public XhtmlCodeExample(boolean useFontAwesome) {
        this("xhtml", "xhtml", useFontAwesome);
    }

    public XhtmlCodeExample(String tabName, String tabId, boolean useFontAwesome) {
        super(tabName, tabId);
        this.useFontAwesome = useFontAwesome;
    }

    public String getPrettyPrintLang() {
        return "lang-html";
    }

    public StringBuilder appendInnerContent(String content) {
        return this.appendInnerContent(content, true);
    }

    public StringBuilder appendInnerContent(String content, boolean lineBreak) {
        if (lineBreak) {
            return this.innerContent.append(content).append("\n");
        }
        return this.innerContent.append(content);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html> \n");
        stringBuilder.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" \n");
        stringBuilder.append("      xmlns:h=\"http://java.sun.com/jsf/html\" \n");
        stringBuilder.append("      xmlns:f=\"http://java.sun.com/jsf/core\" \n");
        stringBuilder.append("      xmlns:b=\"http://butterfaces.larmic.de/components\"> \n");
        if (this.useFontAwesome) {
            stringBuilder.append("<h:head> \n");
            stringBuilder.append("    <link href=\"//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css\"\n");
            stringBuilder.append("          rel=\"stylesheet\">\n");
            stringBuilder.append("</h:head> \n");
        } else {
            stringBuilder.append("<h:head /> \n");
        }
        stringBuilder.append("<body>");
        stringBuilder.append("\n");
        stringBuilder.append("    <form>");
        stringBuilder.append("\n");
        stringBuilder.append(this.innerContent.toString());
        stringBuilder.append("\n");
        stringBuilder.append("    </form> \n");
        stringBuilder.append("</body> \n");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

