/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.showcase.AbstractInputShowcase;
import de.larmic.butterfaces.component.showcase.ComboBoxShowcase;
import de.larmic.butterfaces.component.showcase.comboBox.Foo;
import de.larmic.butterfaces.component.showcase.comboBox.FooConverter;
import de.larmic.butterfaces.component.showcase.comboBox.FooType;
import de.larmic.butterfaces.component.showcase.example.AbstractCodeExample;
import de.larmic.butterfaces.component.showcase.example.CssCodeExample;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.type.ComboBoxValueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class ComboBoxShowcase
extends AbstractInputShowcase
implements Serializable {
    private ComboBoxValueType comboBoxValueType = ComboBoxValueType.STRING;
    private boolean filterable;
    private boolean autoFocus;
    private final List<SelectItem> foos = new ArrayList();
    private final List<SelectItem> enums = new ArrayList();
    private final List<SelectItem> strings = new ArrayList();

    public ComboBoxShowcase() {
        this.initFoos();
        this.initStrings();
        this.initEnums();
    }

    protected Object initValue() {
        return null;
    }

    public void buildCodeExamples(List<AbstractCodeExample> codeExamples) {
        XhtmlCodeExample xhtmlCodeExample = new XhtmlCodeExample(false);
        xhtmlCodeExample.appendInnerContent("        <b:comboBox id=\"input\"");
        xhtmlCodeExample.appendInnerContent("                    label=\"" + this.getLabel() + "\"");
        xhtmlCodeExample.appendInnerContent("                    value=\"" + this.getValue() + "\"");
        xhtmlCodeExample.appendInnerContent("                    tooltip=\"" + this.getTooltip() + "\"");
        xhtmlCodeExample.appendInnerContent("                    styleClass=\"" + this.getStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    inputStyleClass=\"" + this.getInputStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    labelStyleClass=\"" + this.getLabelStyleClass() + "\"");
        xhtmlCodeExample.appendInnerContent("                    readonly=\"" + this.isReadonly() + "\"");
        xhtmlCodeExample.appendInnerContent("                    required=\"" + this.isRequired() + "\"");
        xhtmlCodeExample.appendInnerContent("                    filterable=\"" + this.filterable + "\"");
        xhtmlCodeExample.appendInnerContent("                    autoFocus=\"" + this.isAutoFocus() + "\"");
        xhtmlCodeExample.appendInnerContent("                    rendered=\"" + this.isRendered() + "\">");
        this.addAjaxTag(xhtmlCodeExample, "keyup");
        if (this.comboBoxValueType == ComboBoxValueType.STRING) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"#{null}\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Choose one...\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2000\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2000\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2010\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2010\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:selectItem itemValue=\"2020\"");
            xhtmlCodeExample.appendInnerContent("                          itemLabel=\"Year 2020\"/>");
        } else if (this.comboBoxValueType == ComboBoxValueType.ENUM) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItems value=\"#{bean.fooEnums}\"/>");
        } else if (this.comboBoxValueType == ComboBoxValueType.OBJECT) {
            xhtmlCodeExample.appendInnerContent("            <f:selectItems value=\"#{bean.fooObjects}\"/>");
            xhtmlCodeExample.appendInnerContent("            <f:converter converterId=\"fooConverter\"/>    ");
        }
        xhtmlCodeExample.appendInnerContent("        </b:comboBox>", false);
        this.addOutputExample(xhtmlCodeExample);
        codeExamples.add((AbstractCodeExample)xhtmlCodeExample);
        if (StringUtils.isNotEmpty((String)this.getStyleClass())) {
            CssCodeExample cssCodeExample = new CssCodeExample();
            cssCodeExample.addCss(".some-demo-class", new String[]{"background-color: red;"});
            codeExamples.add((AbstractCodeExample)cssCodeExample);
        }
    }

    public Object getValue() {
        if (super.getValue() != null) {
            return super.getValue().toString();
        }
        return "(item is null)";
    }

    public String getReadableValue() {
        if (super.getValue() != null) {
            if (super.getValue() instanceof Foo) {
                return ((Foo)super.getValue()).getValue();
            }
            if (super.getValue() instanceof FooType) {
                return ((FooType)super.getValue()).label;
            }
            return (String)super.getValue();
        }
        return "(item is null)";
    }

    public List<SelectItem> getValues() {
        switch (1.$SwitchMap$de$larmic$butterfaces$component$showcase$type$ComboBoxValueType[this.comboBoxValueType.ordinal()]) {
            case 1: {
                return this.foos;
            }
            case 2: {
                return this.enums;
            }
        }
        return this.strings;
    }

    public boolean isConverterActive() {
        return this.comboBoxValueType == ComboBoxValueType.OBJECT;
    }

    public List<SelectItem> getComboBoxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ComboBoxValueType type : ComboBoxValueType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public ComboBoxValueType getComboBoxValueType() {
        return this.comboBoxValueType;
    }

    public void setComboBoxValueType(ComboBoxValueType comboBoxValueType) {
        this.comboBoxValueType = comboBoxValueType;
    }

    public boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    private void initFoos() {
        this.foos.add(new SelectItem(null, "Choose one..."));
        for (String key : FooConverter.fooMap.keySet()) {
            Foo foo = (Foo)FooConverter.fooMap.get(key);
            this.foos.add(new SelectItem((Object)foo, foo.getKey()));
        }
    }

    private void initEnums() {
        this.enums.add(new SelectItem(null, "Choose one..."));
        for (FooType fooType : FooType.values()) {
            this.enums.add(new SelectItem((Object)fooType.label));
        }
    }

    private void initStrings() {
        this.strings.add(new SelectItem(null, "Choose one..."));
        this.strings.add(new SelectItem((Object)"2000", "Year 2000"));
        this.strings.add(new SelectItem((Object)"2010", "Year 2010"));
        this.strings.add(new SelectItem((Object)"2020", "Year 2020"));
    }
}

