/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.showcase;

import de.larmic.butterfaces.component.showcase.AbstractCodeShowcase;
import de.larmic.butterfaces.component.showcase.example.XhtmlCodeExample;
import de.larmic.butterfaces.component.showcase.type.AjaxType;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

public abstract class AbstractInputShowcase
extends AbstractCodeShowcase {
    protected static final String DEFAULT_NUMBER_PLACEHOLDER = "Enter number...";
    protected static final String DEFAULT_TEXT_PLACEHOLDER = "Enter text...";
    private Object value;
    private String label = "label";
    private String tooltip = "tooltip";
    private boolean readonly;
    private boolean required;
    private boolean validation;
    private boolean hideLabel;
    private AjaxType ajaxType = AjaxType.NONE;
    private String inputStyleClass = null;
    private String labelStyleClass = null;
    private String styleClass = null;

    public AbstractInputShowcase() {
        this.value = this.initValue();
    }

    protected abstract Object initValue();

    public abstract String getReadableValue();

    public boolean isAjax() {
        return AjaxType.NONE != this.getAjaxType();
    }

    public List<SelectItem> getAjaxTypes() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (AjaxType type : AjaxType.values()) {
            items.add(new SelectItem((Object)type, type.label));
        }
        return items;
    }

    public List<SelectItem> getInputStyleClasses() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)"col-sm-1", "col-sm-1"));
        items.add(new SelectItem((Object)"col-sm-2", "col-sm-2"));
        items.add(new SelectItem((Object)"col-sm-3", "col-sm-3"));
        items.add(new SelectItem((Object)"col-sm-4", "col-sm-4"));
        items.add(new SelectItem((Object)"col-sm-5", "col-sm-5"));
        items.add(new SelectItem((Object)"col-sm-6", "col-sm-6"));
        items.add(new SelectItem((Object)"col-sm-7", "col-sm-7"));
        items.add(new SelectItem((Object)"col-sm-8", "col-sm-8"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-9"));
        items.add(new SelectItem(null, "default (col-sm-10)"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-11"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-12"));
        return items;
    }

    public List<SelectItem> getLabelStyleClasses() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)"col-sm-1", "col-sm-1"));
        items.add(new SelectItem(null, "default (col-sm-2)"));
        items.add(new SelectItem((Object)"col-sm-3", "col-sm-3"));
        items.add(new SelectItem((Object)"col-sm-4", "col-sm-4"));
        items.add(new SelectItem((Object)"col-sm-5", "col-sm-5"));
        items.add(new SelectItem((Object)"col-sm-6", "col-sm-6"));
        items.add(new SelectItem((Object)"col-sm-7", "col-sm-7"));
        items.add(new SelectItem((Object)"col-sm-8", "col-sm-8"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-10"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-11"));
        items.add(new SelectItem((Object)"col-sm-9", "col-sm-12"));
        return items;
    }

    public List<SelectItem> getStyleClasses() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem(null, "default (null)"));
        items.add(new SelectItem((Object)"some-demo-class", "some-demo-class"));
        return items;
    }

    public void addAjaxTag(XhtmlCodeExample codeExample, String event) {
        if (this.isAjax()) {
            String execute = AjaxType.THIS == this.ajaxType ? "@this" : "input";
            codeExample.appendInnerContent("            <f:ajax event=\"" + event + "\"  execute=\"" + execute + "\" render=\"output\"/>");
        }
    }

    public void addOutputExample(XhtmlCodeExample codeExample) {
        if (this.isAjax()) {
            codeExample.appendInnerContent("\n        <h:outputText id=\"output\" value=\"" + this.getValue() + "\"/>");
        }
    }

    public void submit() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public AjaxType getAjaxType() {
        return this.ajaxType;
    }

    public void setAjaxType(AjaxType ajax) {
        this.ajaxType = ajax;
    }

    public boolean isHideLabel() {
        return this.hideLabel;
    }

    public void setHideLabel(boolean hideLabel) {
        this.hideLabel = hideLabel;
    }

    public String getInputStyleClass() {
        return this.inputStyleClass;
    }

    public void setInputStyleClass(String inputStyleClass) {
        this.inputStyleClass = inputStyleClass;
    }

    public String getLabelStyleClass() {
        return this.labelStyleClass;
    }

    public void setLabelStyleClass(String labelStyleClass) {
        this.labelStyleClass = labelStyleClass;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

