package de.larmic.butterfaces.component.showcase;

import java.io.Serializable;
import java.lang.String;
import java.lang.StringBuilder;

/**
 * Contains butterfaces maven pom.xml informations. templating-maven-plugin is used in pom.xml.
 */
@javax.inject.Named
@javax.faces.view.ViewScoped
@SuppressWarnings("serial")
public class Version implements Serializable {

    private static final String VERSION = "1.9.5";
    private static final String GROUPID = "de.larmic.butterfaces";
    private static final String ARTIFACTID = "showcase-shared";
    private static final String REVISION = "6f520cd5df5884af60e4707cfef1c63c20992054";
    private static final String JBOSS = "9.0.1.Final";

    public String getVersion() {
        return VERSION;
    }

    public String getLastestReleaseVersion() {
        if (VERSION.endsWith("SNAPSHOT")) {
            final String version = VERSION.replaceAll("-SNAPSHOT", "");
            final String[] splitted = version.split("\\.");
            final String newMinorVersion = Integer.valueOf(splitted[splitted.length-1])-1 + "";

            final StringBuilder stringBuilder = new StringBuilder();
            for (int i=0; i<splitted.length-1; i++) {
                stringBuilder.append(splitted[i]);
                stringBuilder.append(".");
            }
            stringBuilder.append(newMinorVersion);

            return stringBuilder.toString();
        }

        return VERSION;
    }

    public String getGroupId() {
        return GROUPID;
    }

    public String getArtifactId() {
        return ARTIFACTID;
    }

    public String getRevision() {
        return REVISION;
    }

    public String getJBossVersion() {
        return JBOSS;
    }
}