package de.larmic.butterfaces.component.showcase;

import java.io.Serializable;

/**
 * Contains butterfaces maven pom.xml informations. templating-maven-plugin is used in pom.xml.
 */
@javax.inject.Named
@javax.faces.view.ViewScoped
@SuppressWarnings("serial")
public class Version implements Serializable {

    private static final String ERROR_VERSION = "1.9.0.CR3";

    private static final String VERSION = "1.9.0.CR4";
    private static final String GROUPID = "de.larmic.butterfaces";
    private static final String ARTIFACTID = "showcase-shared";
    private static final String REVISION = "31f080bd14e424102bafd95fc7211d51d3d5b9b5";
    private static final String JBOSS = "9.0.1.Final";

    public String getVersion() {
        return VERSION;
    }

    public String getLastestReleaseVersion() {
        if (VERSION.endsWith("SNAPSHOT")) {
            final String version = VERSION.replaceAll("-SNAPSHOT", "");
            final String[] splitted = version.split("\\.");
            final Integer minorVersion = getMinorVersion(splitted[splitted.length - 1]);

            if (minorVersion != null) {
                final StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < splitted.length - 1; i++) {
                    stringBuilder.append(splitted[i]);
                    stringBuilder.append(".");
                }
                stringBuilder.append(minorVersion);
            }

            return ERROR_VERSION;
        }

        return VERSION;
    }

    /**
     * @return null if value is not parsable or value is less than 0.
     */
    private Integer getMinorVersion(final String value) {
        try {
            final Integer newMinorVersion = Integer.valueOf(value) - 1;
            return newMinorVersion >= 0 ? newMinorVersion : null;
        } catch (NumberFormatException e) {
            return null;
        }
    }

    public String getGroupId() {
        return GROUPID;
    }

    public String getArtifactId() {
        return ARTIFACTID;
    }

    public String getRevision() {
        return REVISION;
    }

    public String getJBossVersion() {
        return JBOSS;
    }
}