/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.partrenderer.ExpandablePartRenderer;
import de.larmic.butterfaces.component.partrenderer.HtmlAttributePartRenderer;
import de.larmic.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.LabelPartRenderer;
import de.larmic.butterfaces.component.partrenderer.MaxLengthPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.partrenderer.TooltipPartRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.TextAreaRenderer")
public class TextAreaRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.INPUTTEXTAREA);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        new OuterComponentWrapperPartRenderer().renderComponentBegin(component, writer, this.getComponentNameStyleClass());
        new LabelPartRenderer().renderLabel(component, writer);
        new InnerComponentWrapperPartRenderer().renderInnerWrapperBegin(component, writer);
        new ReadonlyPartRenderer().renderReadonly(htmlComponent, writer);
    }

    protected String getComponentNameStyleClass() {
        return "butter-component-textarea";
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!htmlComponent.isReadonly()) {
            super.encodeEnd(context, component);
        }
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd(component, writer);
        this.renderTooltipIfNecessary(context, component);
        this.renderAdditionalScript(context, component);
        new MaxLengthPartRenderer().renderMaxLength(htmlComponent, writer);
        this.renderExpandable(htmlComponent, writer);
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    protected void renderExpandable(HtmlInputComponent htmlComponent, ResponseWriter writer) throws IOException {
        new ExpandablePartRenderer().renderExpandable(htmlComponent, writer);
    }

    protected void renderAdditionalScript(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderTooltipIfNecessary(FacesContext context, UIComponent component) throws IOException {
        new TooltipPartRenderer().renderTooltipIfNecessary(context, component);
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("textarea", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String styleClass = StringUtils.concatWithSpace((String[])new String[]{"butter-input-component", "form-control", !((HtmlInputComponent)component).isValid() ? "butter-component-invalid" : null});
        if (StringUtils.isNotEmpty((String)styleClass)) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderHtmlFeatures(component, writer);
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
        RenderKitUtils.renderOnchange((FacesContext)context, (UIComponent)component, (boolean)false);
        if (currentValue != null) {
            writer.writeText((Object)currentValue, component, "value");
        }
        writer.endElement("textarea");
    }

    protected void renderHtmlFeatures(UIComponent component, ResponseWriter writer) throws IOException {
        new HtmlAttributePartRenderer().renderHtmlFeatures(component, writer);
    }
}

