/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.HtmlTooltip;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.renderkit.html_basic.table.TableToolbarRenderer;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.resolver.AjaxRequest;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.ColumnRenderer")
public class ColumnRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        HtmlColumn column = (HtmlColumn)component;
        HtmlTable table = this.findParentTable(component);
        int columnNumber = column.getColumnNumberUsedByTable();
        AjaxRequest ajaxRequest = column.getTableAjaxClickRequest();
        WebXmlParameters webXmlParameters = column.getWebXmlParameters();
        HtmlTooltip tooltip = this.findTooltip(component);
        writer.startElement("th", component);
        writer.writeAttribute("id", (Object)column.getClientId(), null);
        if (column.isSortColumnEnabled() && table.getTableSortModel() != null) {
            writer.writeAttribute("class", (Object)"butter-component-table-column-header butter-component-table-column-sort", null);
        } else {
            writer.writeAttribute("class", (Object)"butter-component-table-column-header", null);
        }
        writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
        if (this.isHideColumn(table, column)) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (column.isSortColumnEnabled() && table.getModel() != null && ajaxRequest != null) {
            String ajax = TableToolbarRenderer.createModelJavaScriptCall(table.getClientId(), ajaxRequest.getRenderIds(), "sortRow", table.isAjaxDisableRenderRegionsOnRequest(), columnNumber + "");
            writer.writeAttribute("onclick", (Object)ajax, null);
        }
        writer.startElement("div", component);
        writer.writeAttribute("data-tooltip-identifier", (Object)this.createTooltipIdentifier(column), null);
        writer.writeAttribute("class", (Object)column.getHeaderStyleClass(), null);
        writer.writeAttribute("style", (Object)column.getHeaderStyle(), null);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"butter-component-table-column-label", null);
        writer.writeText((Object)column.getLabel(), null);
        writer.endElement("span");
        if (column.isSortColumnEnabled() && table.getTableSortModel() != null && ajaxRequest != null) {
            writer.startElement("span", component);
            String tableUniqueIdentifier = table.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            SortType sortType = table.getModel().getTableRowSortingModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier);
            StringBuilder sortSpanStyleClass = new StringBuilder("butter-component-table-column-sort-spinner ");
            if (sortType == SortType.ASCENDING) {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortAscGlyphicon());
            } else if (sortType == SortType.DESCENDING) {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortDescGlyphicon());
            } else {
                sortSpanStyleClass.append(" " + webXmlParameters.getSortUnknownGlyphicon());
            }
            writer.writeAttribute("class", (Object)sortSpanStyleClass.toString(), null);
            writer.endElement("span");
        }
        if (tooltip != null) {
            tooltip.setFor("[data-tooltip-identifier=\"" + this.createTooltipIdentifier(column) + "\"]");
            tooltip.encodeAll(context);
        }
    }

    private String createTooltipIdentifier(HtmlColumn column) {
        return column.getClientId() + "_div";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected boolean shouldEncodeChildren(UIComponent component) {
        return false;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("th");
    }

    private HtmlTooltip findTooltip(UIComponent component) {
        for (UIComponent uiComponent : component.getChildren()) {
            if (!(uiComponent instanceof HtmlTooltip)) continue;
            return (HtmlTooltip)uiComponent;
        }
        return null;
    }

    private HtmlTable findParentTable(UIComponent component) {
        return component instanceof HtmlTable || component == null ? (HtmlTable)component : this.findParentTable(component.getParent());
    }

    private boolean isHideColumn(HtmlTable table, HtmlColumn column) {
        if (table.getTableColumnVisibilityModel() != null) {
            String tableUniqueIdentifier = table.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            Boolean hideColumn = table.getTableColumnVisibilityModel().isColumnHidden(tableUniqueIdentifier, columnUniqueIdentifier);
            if (hideColumn != null) {
                return hideColumn;
            }
        }
        return column.isHideColumn();
    }
}

