/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.html.HtmlMarkdown;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.TextAreaRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.MarkdownRenderer")
public class MarkdownRenderer
extends TextAreaRenderer {
    @Override
    protected void renderAdditionalScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        HtmlMarkdown markdown = (HtmlMarkdown)component;
        writer.startElement("script", (UIComponent)markdown);
        if (!markdown.isReadonly()) {
            writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)"textarea", (String)this.createJQueryMarkdownPluginCall(markdown)), null);
        } else {
            writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), null, (String)this.createJQueryMarkdownToHtmlPluginCall()), null);
        }
        writer.endElement("script");
    }

    @Override
    protected void renderExpandable(HtmlInputComponent htmlComponent, ResponseWriter writer) throws IOException {
    }

    @Override
    protected String getComponentNameStyleClass() {
        return "butter-component-markdown";
    }

    private String createJQueryMarkdownPluginCall(HtmlMarkdown markdown) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("markdown({");
        jQueryPluginCall.append("autofocus: false,");
        jQueryPluginCall.append("savable: false,");
        jQueryPluginCall.append("language: '" + markdown.getLanguage() + "'");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }

    private String createJQueryMarkdownToHtmlPluginCall() {
        return "markdownReadonly()";
    }
}

