/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.text;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.html.HtmlTooltip;
import de.larmic.butterfaces.component.html.InputComponentFacet;
import de.larmic.butterfaces.component.html.text.HtmlText;
import de.larmic.butterfaces.component.partrenderer.HtmlAttributePartRenderer;
import de.larmic.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.LabelPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.partrenderer.TooltipPartRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class AbstractTextRenderer<T extends HtmlInputComponent>
extends HtmlBasicInputRenderer {
    private static final Attribute[] INPUT_ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.INPUTTEXT);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBegin(context, component, "");
    }

    public void encodeBegin(FacesContext context, UIComponent component, String additionalStyleClass) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        new OuterComponentWrapperPartRenderer().renderComponentBegin(component, writer, additionalStyleClass);
        new LabelPartRenderer().renderLabel(component, writer);
        this.encodeBeginInnerWrapper(component, writer);
        this.encodeReadonly(htmlComponent, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!htmlComponent.isReadonly()) {
            this.encodeEndContent(context, component, htmlComponent, writer);
        }
        this.encodeInnerEnd(component, writer);
        this.encodeEndInnerWrapper(component, writer);
        this.renderTooltipIfNecessary(context, component);
        this.encodeEnd(component, writer);
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    protected void renderTooltipIfNecessary(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent uiComponent : component.getChildren()) {
            if (!(uiComponent instanceof HtmlTooltip)) continue;
            uiComponent.encodeAll(context);
            if (!uiComponent.isRendered()) continue;
            break;
        }
        new TooltipPartRenderer().renderTooltipIfNecessary(context, component);
    }

    protected void encodeEndContent(FacesContext context, UIComponent component, HtmlInputComponent htmlComponent, ResponseWriter writer) throws IOException {
        UIComponent inputGroupAddonLeftFacet = component.getFacet("input-group-addon-left");
        UIComponent inputGroupAddonRightFacet = component.getFacet("input-group-addon-right");
        UIComponent inputGroupBtnLeftFacet = component.getFacet("input-group-btn-left");
        UIComponent inputGroupBtnRightFacet = component.getFacet("input-group-btn-right");
        if (htmlComponent.getSupportedFacets().contains(InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_ADDON) && inputGroupAddonLeftFacet != null) {
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-addon", null);
            inputGroupAddonLeftFacet.encodeAll(context);
            writer.endElement("span");
        }
        if (htmlComponent.getSupportedFacets().contains(InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_BTN) && inputGroupBtnLeftFacet != null) {
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-btn", null);
            inputGroupBtnLeftFacet.encodeAll(context);
            writer.endElement("span");
        }
        super.encodeEnd(context, component);
        this.postEncodeInput(context, component);
        if (htmlComponent.getSupportedFacets().contains(InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_ADDON) && inputGroupAddonRightFacet != null) {
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-addon", null);
            inputGroupAddonRightFacet.encodeAll(context);
            writer.endElement("span");
        }
        if (htmlComponent.getSupportedFacets().contains(InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_BTN) && inputGroupBtnRightFacet != null) {
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-btn", null);
            inputGroupBtnRightFacet.encodeAll(context);
            writer.endElement("span");
        }
    }

    protected void postEncodeInput(FacesContext context, UIComponent component) throws IOException {
    }

    protected boolean encodeReadonly() {
        return true;
    }

    protected void encodeReadonly(T htmlComponent, ResponseWriter writer) throws IOException {
        if (this.encodeReadonly()) {
            new ReadonlyPartRenderer().renderReadonly(htmlComponent, writer);
        }
    }

    protected void encodeEndInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd(component, writer);
    }

    protected void encodeBeginInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        new InnerComponentWrapperPartRenderer().renderInnerWrapperBegin(component, writer);
    }

    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void encodeEnd(UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void encodeSuperEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (component instanceof UIInput) {
            String styleClass;
            writer.startElement("input", component);
            writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
            if ("off".equals(component.getAttributes().get("autocomplete"))) {
                writer.writeAttribute("autocomplete", (Object)"off", "autocomplete");
            }
            if (currentValue != null) {
                writer.writeAttribute("value", (Object)currentValue, "value");
            }
            if (StringUtils.isNotEmpty((String)(styleClass = StringUtils.concatWithSpace((String[])new String[]{"butter-input-component", "form-control", !((HtmlInputComponent)component).isValid() ? "butter-component-invalid" : null})))) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            this.renderHtmlFeatures(component, writer);
            this.renderAdditionalInputAttributes(context, component, writer);
            RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])INPUT_ATTRIBUTES, (Map)AbstractTextRenderer.getNonOnChangeBehaviors((UIComponent)component));
            RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
            RenderKitUtils.renderOnchange((FacesContext)context, (UIComponent)component, (boolean)false);
            writer.endElement("input");
        }
    }

    protected void renderAdditionalInputAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren = WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AllowTextChildren);
        if (!renderChildren) {
            return;
        }
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }

    protected void renderHtmlFeatures(UIComponent component, ResponseWriter writer) throws IOException {
        new HtmlAttributePartRenderer().renderHtmlFeatures(component, writer);
        if (component instanceof HtmlText) {
            HtmlText inputComponent = (HtmlText)component;
            HtmlAttributePartRenderer htmlAttributePartRenderer = new HtmlAttributePartRenderer();
            htmlAttributePartRenderer.writePatternAttribute(writer, inputComponent.getPattern());
            htmlAttributePartRenderer.writeMinAttribute(writer, inputComponent.getMin());
            htmlAttributePartRenderer.writeMaxAttribute(writer, inputComponent.getMax());
            htmlAttributePartRenderer.writeTypeAttribute(writer, inputComponent.getType());
        }
        writer.writeAttribute("type", (Object)"text", null);
    }
}

