/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.event.TableSingleSelectionListener;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.resolver.AjaxRequest;
import de.larmic.butterfaces.resolver.AjaxRequestFactory;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.TableRenderer")
public class TableRenderer
extends de.larmic.butterfaces.component.renderkit.html_basic.mojarra.TableRenderer {
    private boolean hasColumnWidthSet;
    private int rowIndex;
    private boolean foundSelectedRow;
    private WebXmlParameters webXmlParameters;

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlTable table = (HtmlTable)component;
        this.hasColumnWidthSet = this.hasColumnWidthSet(table.getCachedColumns());
        this.rowIndex = 0;
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        this.foundSelectedRow = false;
        super.encodeBegin(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter responseWriter = context.getResponseWriter();
        RenderUtils.renderJQueryPluginCall((String)component.getClientId(), (String)"fixBootstrapDropDown()", (ResponseWriter)responseWriter, (UIComponent)component);
    }

    @Override
    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        int columnNumber;
        HtmlTable htmlTable = (HtmlTable)table;
        if (this.hasColumnWidthSet) {
            writer.startElement("colgroup", table);
            columnNumber = 0;
            for (HtmlColumn column : htmlTable.getCachedColumns()) {
                writer.startElement("col", table);
                writer.writeAttribute("class", (Object)"butter-table-colgroup", null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                StringBuilder style = new StringBuilder();
                if (StringUtils.isNotEmpty((String)column.getColWidth())) {
                    style.append("width: ");
                    style.append(column.getColWidth());
                }
                if (this.isHideColumn(htmlTable, column)) {
                    if (style.length() > 0) {
                        style.append("; ");
                    }
                    style.append("display: none");
                }
                if (style.length() > 0) {
                    writer.writeAttribute("style", (Object)style.toString(), null);
                }
                writer.endElement("col");
                ++columnNumber;
            }
            writer.endElement("colgroup");
        }
        writer.startElement("thead", table);
        writer.startElement("tr", table);
        columnNumber = 0;
        AjaxRequest ajaxRequest = new AjaxRequestFactory().createRequest((UIComponentBase)htmlTable, "click");
        if (ajaxRequest != null) {
            ajaxRequest.getRenderIds().add(htmlTable.getClientId());
        }
        for (HtmlColumn column : htmlTable.getCachedColumns()) {
            column.setWebXmlParameters(this.webXmlParameters);
            column.setColumnNumberUsedByTable(columnNumber);
            column.setTableAjaxClickRequest(ajaxRequest);
            column.encodeAll(context);
            ++columnNumber;
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    private boolean isHideColumn(HtmlTable table, HtmlColumn column) {
        if (table.getTableColumnDisplayModel() != null) {
            String tableUniqueIdentifier = table.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            Boolean hideColumn = table.getTableColumnDisplayModel().isColumnHidden(tableUniqueIdentifier, columnUniqueIdentifier);
            if (hideColumn != null) {
                return hideColumn;
            }
        }
        return column.isHideColumn();
    }

    protected void renderTableStart(FacesContext context, UIComponent component, ResponseWriter writer, Attribute[] attributes) throws IOException {
        HtmlTable table = (HtmlTable)component;
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"butter-table", null);
        writer.startElement("div", (UIComponent)table);
        String styleClass = (String)table.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)("table-responsive " + styleClass), "styleClass");
        } else {
            writer.writeAttribute("class", (Object)"table-responsive", "styleClass");
        }
        writer.startElement("table", (UIComponent)table);
        StringBuilder tableStyleClass = new StringBuilder("table table-hover");
        if (this.hasColumnWidthSet) {
            tableStyleClass.append(" table-fixed");
        }
        if (table.isTableCondensed()) {
            tableStyleClass.append(" table-condensed");
        }
        if (table.isTableBordered()) {
            tableStyleClass.append(" table-bordered");
        }
        if (table.isTableStriped()) {
            tableStyleClass.append(" table-striped");
        }
        writer.writeAttribute("class", (Object)tableStyleClass.toString(), "styleClass");
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)table, (Attribute[])attributes);
        writer.writeText((Object)"\n", (UIComponent)table, null);
    }

    protected void renderTableEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        super.renderTableEnd(context, component, writer);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderRowStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String click;
        String rowClass;
        HtmlTable htmlTable = (HtmlTable)component;
        ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)htmlTable, (String)"click", (String)component.getClientId(context), null);
        String clientId = htmlTable.getClientId();
        String baseClientId = clientId.substring(0, clientId.length() - (this.rowIndex + "").length() - 1);
        writer.startElement("tr", (UIComponent)htmlTable);
        writer.writeAttribute("rowIndex", (Object)this.rowIndex, null);
        String string = rowClass = StringUtils.isNotEmpty((String)htmlTable.getRowClass()) ? "butter-table-row " + htmlTable.getRowClass() : "butter-table-row";
        if (!this.foundSelectedRow && this.isRowSelected(htmlTable, this.rowIndex)) {
            writer.writeAttribute("class", (Object)(rowClass + " butter-table-row-selected"), null);
            this.foundSelectedRow = true;
        } else {
            writer.writeAttribute("class", (Object)rowClass, null);
        }
        Map behaviors = htmlTable.getClientBehaviors();
        if (behaviors.containsKey("click") && StringUtils.isNotEmpty((String)(click = ((ClientBehavior)((List)behaviors.get("click")).get(0)).getScript(behaviorContext))) && htmlTable.getSingleSelectionListener() != null) {
            String ajaxCall = new AjaxRequest((UIComponentBase)htmlTable, "click").createJavaScriptCall("click_" + this.rowIndex);
            String aThis = ajaxCall.replaceFirst(clientId, baseClientId);
            String jQueryPluginCall = RenderUtils.createJQueryPluginCall((String)htmlTable.getClientId(), (String)("selectRow({rowIndex:'" + this.rowIndex + "'})"));
            writer.writeAttribute("onclick", (Object)(aThis + ";" + jQueryPluginCall.replaceFirst(clientId, baseClientId)), null);
        }
        writer.writeText((Object)"\n", (UIComponent)htmlTable, null);
        ++this.rowIndex;
    }

    private boolean isRowSelected(HtmlTable table, int rowIndex) {
        if (table.getSingleSelectionListener() != null) {
            Object rowObject = this.findRowObject(table, rowIndex);
            return table.getSingleSelectionListener().isValueSelected(rowObject);
        }
        return false;
    }

    public void decode(FacesContext context, UIComponent component) {
        HtmlTable table = (HtmlTable)component;
        Map behaviors = table.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Object untypedTableValue = table.getValue();
        if (!(untypedTableValue instanceof Iterable)) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && behaviorEvent.contains("_")) {
            String[] split = behaviorEvent.split("_");
            String event = split[0];
            try {
                int eventNumber = Integer.valueOf(split[1]);
                if ("click".equals(event)) {
                    TableSingleSelectionListener listener;
                    Object rowObject = this.findRowObject(table, eventNumber);
                    if (rowObject != null && (listener = table.getSingleSelectionListener()) != null) {
                        listener.processTableSelection(rowObject);
                    }
                } else if ("sort".equals(event) && table.getModel() != null) {
                    HtmlColumn sortedColumn = (HtmlColumn)table.getCachedColumns().get(eventNumber);
                    String tableUniqueIdentifier = table.getModelUniqueIdentifier();
                    String columnUniqueIdentifier = sortedColumn.getModelUniqueIdentifier();
                    if (table.getTableSortModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier) == SortType.ASCENDING) {
                        table.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.DESCENDING);
                    } else {
                        table.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.ASCENDING);
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private Object findRowObject(HtmlTable table, int row) {
        Object value = table.getValue();
        if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            int actualRow = 0;
            while (iterator.hasNext()) {
                Object value1 = iterator.next();
                if (actualRow == row) {
                    return value1;
                }
                ++actualRow;
            }
            return null;
        }
        return null;
    }

    private boolean hasColumnWidthSet(List<HtmlColumn> columns) {
        for (HtmlColumn column : columns) {
            if (!StringUtils.isNotEmpty((String)column.getColWidth())) continue;
            return true;
        }
        return false;
    }
}

