/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.reflect;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public String getValueFromObject(Object object, String fieldName) {
        String value = this.getValuePropertyByField(object, fieldName);
        if (value == null) {
            value = this.getValuePropertyByGetter(object, fieldName);
        }
        return value;
    }

    public String getValuePropertyByField(Object object, String fieldName) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return this.convertToString(declaredField.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    public String getValuePropertyByGetter(Object object, String fieldName) {
        try {
            Method method = object.getClass().getMethod("get" + this.toUpperCase(fieldName), new Class[0]);
            Object valueObject = method.invoke(object, (Object[])null);
            return this.convertToString(valueObject);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private String toUpperCase(String str) {
        return Character.toString(str.charAt(0)).toUpperCase() + str.substring(1);
    }

    private String convertToString(Object object) throws IllegalAccessException {
        String rowIdentifierAsString;
        if (object != null && StringUtils.isNotEmpty((String)(rowIdentifierAsString = object.toString()))) {
            return rowIdentifierAsString;
        }
        return null;
    }
}

